/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.exporters.OdsExporter;
import com.google.refine.exporters.StreamExporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Properties;
import org.mockito.Mockito;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class OdsExporterTests
extends RefineTest {
    private static final String TEST_PROJECT_NAME = "ods exporter test project";
    ByteArrayOutputStream stream;
    ProjectMetadata projectMetadata;
    Project project;
    Engine engine;
    Properties options;
    StreamExporter SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new OdsExporter();
        this.stream = new ByteArrayOutputStream();
        ProjectManager.singleton = new ProjectManagerStub();
        this.projectMetadata = new ProjectMetadata();
        this.project = new Project();
        this.projectMetadata.setName(TEST_PROJECT_NAME);
        ProjectManager.singleton.registerProject(this.project, this.projectMetadata);
        this.engine = new Engine(this.project);
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.stream = null;
        ProjectManager.singleton.deleteProject(this.project.id);
        this.project = null;
        this.engine = null;
        this.options = null;
    }

    @Test
    public void getContentType() {
        Assert.assertEquals((String)this.SUT.getContentType(), (String)"application/vnd.oasis.opendocument.spreadsheet");
    }

    @Test
    public void exportSimpleOds() throws IOException {
        this.CreateGrid(2, 2);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            OdfDocument odfDoc = OdfDocument.loadDocument((InputStream)new ByteArrayInputStream(this.stream.toByteArray()));
            List tables = odfDoc.getTableList();
            Assert.assertEquals((int)tables.size(), (int)1);
            OdfTable odfTab = (OdfTable)tables.get(0);
            Assert.assertEquals((String)odfTab.getTableName(), (String)TEST_PROJECT_NAME);
            Assert.assertEquals((int)odfTab.getRowCount(), (int)3);
            Assert.assertEquals((String)odfTab.getRowByIndex(1).getCellByIndex(0).getStringValue(), (String)"row0cell0");
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    protected void CreateColumns(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void CreateGrid(int noOfRows, int noOfColumns) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }

    private void createDateGrid(int noOfRows, int noOfColumns, OffsetDateTime now) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)now, null));
            }
            this.project.rows.add(row);
        }
    }
}

