/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.util.CalendarParser;
import com.google.refine.expr.util.CalendarParserException;
import java.time.OffsetDateTime;
import java.util.TimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ToDateTests
extends RefineTest {
    @Test
    public void testToDate() throws CalendarParserException {
        TimeZone originalTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("JST"));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", new Object[0]) instanceof EvalError));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", new Object[]{null}) instanceof EvalError));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", "") instanceof EvalError));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", 1.0) instanceof EvalError));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", "2012-03-01", "xxx") instanceof EvalError));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", "2012-03-01", 1L) instanceof EvalError));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", "P1M") instanceof EvalError));
            Assert.assertTrue((boolean)(ToDateTests.invoke("toDate", "2012-03-01") instanceof OffsetDateTime));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "2012-03-01"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-03-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01/03/2012"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-01-03"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01/03/2012", true), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-01-03"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01/03/2012", false), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-03-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01/03/2012", "dd/MM/yyyy"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-03-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "2012-03-01", "yyyy-MM-dd"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-03-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "02-02-01"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2001-02-02"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "2012-03-01", "MMM", "yyyy-MM-dd"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-03-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01/03/2012", false, "MMM", "yyyy-MM-dd", "MM/dd/yyyy"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-03-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "2013-06-01", "zh"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2013-06-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01-\u516d\u6708-2013", "zh", "dd-MMM-yyyy"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2013-06-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01-\u516d\u6708-2013", "zh-CN", "dd-MMM-yyyy"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2013-06-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "01-\u516d\u6708-2013", "zh", "MMM-dd-yyyy", "dd-MMM-yyyy"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2013-06-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", 2012L), (Object)ToDateTests.invoke("toDate", "2012-01-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", CalendarParser.parseAsOffsetDateTime((String)"2012-03-01")), (Object)CalendarParser.parseAsOffsetDateTime((String)"2012-03-01"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "2013-06-01T13:12:11Z"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2013-06-01 13:12:11"));
            Assert.assertEquals((Object)ToDateTests.invoke("toDate", "2013-06-01Z"), (Object)CalendarParser.parseAsOffsetDateTime((String)"2013-06-01"));
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
        }
    }
}

