/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.RefineTest;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.grel.controls.ForEachIndex;
import com.google.refine.util.TestUtils;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ForEachIndexTests
extends RefineTest {
    @Test
    public void serializeForEachIndex() {
        String json = "{\"description\":\"Evaluates expression a to an array. Then for each array element, binds its index to variable i and its value to variable name v, evaluates expression e, and pushes the result onto the result array.\",\"params\":\"expression a, variable i, variable v, expression e\",\"returns\":\"array\"}";
        TestUtils.isSerializedTo(new ForEachIndex(), json);
    }

    private void assertParseException(String expression) {
        this.assertParseException(expression, null);
    }

    private void assertParseException(String expression, String message) {
        try {
            MetaParser.parse((String)("grel:" + expression));
            if (message == null) {
                Assert.fail((String)("Expression didn't return error : " + expression));
            } else {
                Assert.fail((String)message);
            }
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidParams() throws ParsingException {
        bindings = new Properties();
        bindings.put("v", "");
        this.assertParseException("forEachIndex('test', v, v)");
        this.assertParseException("forEachIndex([], 1, 1, 1)", "Didn't throw a ParsingException for wrong argument type");
        this.assertParseException("forEachIndex([], v, v, v)", "Didn't throw ParsingException for duplicate variables");
        this.assertParseException("forEachIndex([], v, v)", "Didn't throw a ParsingException for 3 arguments");
        this.assertParseException("forEachIndex([], v)", "Didn't throw a ParsingException for 2 arguments");
        this.assertParseException("forEachIndex([])", "Didn't throw a ParsingException for 1 argument");
    }

    @Test
    public void testForEachJsonObject() throws ParsingException {
        String json = "{\"2511\": {\"parent_area\": null, \"generation_high\": 40, \"all_names\": {}, \"id\": 2511, \"codes\": {\"ons\": \"00AB\", \"gss\": \"E09000002\", \"local-authority-eng\": \"BDG\", \"local-authority-canonical\": \"BDG\", \"unit_id\": \"10949\"}, \"name\": \"Barking and Dagenham Borough Council\", \"country\": \"E\", \"type_name\": \"London borough\", \"generation_low\": 1, \"country_name\": \"England\", \"type\": \"LBO\"},\"2247\": {\"parent_area\": null, \"generation_high\": 40, \"all_names\": {}, \"id\": 2247, \"codes\": {\"unit_id\": \"41441\"}, \"name\": \"Greater London Authority\", \"country\": \"E\", \"type_name\": \"Greater London Authority\", \"generation_low\": 1, \"country_name\": \"England\", \"type\": \"GLA\"},\"8706\": {\"parent_area\": 2511, \"generation_high\": 40, \"all_names\": {}, \"id\": 8706, \"codes\": {\"ons\": \"00ABGH\", \"gss\": \"E05000036\", \"unit_id\": \"10936\"}, \"name\": \"Mayesbrook\", \"country\": \"E\", \"type_name\": \"London borough ward\", \"generation_low\": 1, \"country_name\": \"England\", \"type\": \"LBW\"}}";
        String[] test = new String[]{"forEachIndex('" + json + "'.parseJson(), k, v, v.id).sort().join(',')", "2247,2511,8706"};
        bindings = new Properties();
        bindings.put("k", "");
        bindings.put("v", "");
        this.parseEval(bindings, test);
        String[] test2 = new String[]{"forEachIndex('" + json + "'.parseJson(), k, v, k).sort().join(',')", "2247,2511,8706"};
        this.parseEval(bindings, test2);
        String[] test3 = new String[]{"forEachIndex('" + json + "'.parseJson(), k, v, k.toNumber()==v.id).join(',')", "true,true,true"};
        this.parseEval(bindings, test3);
    }

    @Test
    public void testForEachIndexArray() throws ParsingException {
        bindings = new Properties();
        bindings.put("k", "");
        bindings.put("v", "");
        this.parseEval(bindings, new String[]{"forEachIndex([5,4,3,2.0], k, v, v*2).join(',')", "10,8,6,4.0"});
        this.parseEval(bindings, new String[]{"forEachIndex([5,4,3,2.0], k, v, k).join(',')", "0,1,2,3"});
    }

    @Test
    public void testForEachIndexJsonArray() throws ParsingException {
        bindings = new Properties();
        bindings.put("k", "");
        bindings.put("v", "");
        this.parseEval(bindings, new String[]{"forEachIndex('[3,2,1.0]'.parseJson(), k, v, v*2).join(',')", "6,4,2.0"});
        this.parseEval(bindings, new String[]{"forEachIndex('[3,2,1.0]'.parseJson(), k, v, k).join(',')", "0,1,2"});
    }
}

