/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.refine.importers.FixedWidthImporter;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FixedWidthImporterTests
extends ImporterTest {
    String SAMPLE_ROW = "NDB_NoShrt_DescWater";
    FixedWidthImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new FixedWidthImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        super.tearDown();
    }

    @Test
    public void readFixedWidth() {
        StringReader reader = new StringReader(this.SAMPLE_ROW + "\nTooShort");
        ArrayNode columnWidths = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)columnWidths, (int)6);
        JSONUtilities.append((ArrayNode)columnWidths, (int)9);
        JSONUtilities.append((ArrayNode)columnWidths, (int)5);
        FixedWidthImporterTests.whenGetArrayOption("columnWidths", this.options, columnWidths);
        ArrayNode columnNames = ParsingUtilities.mapper.createArrayNode();
        columnNames.add("Col 1");
        columnNames.add("Col 2");
        columnNames.add("Col 3");
        FixedWidthImporterTests.whenGetArrayOption("columnNames", this.options, columnNames);
        FixedWidthImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        FixedWidthImporterTests.whenGetIntegerOption("headerLines", this.options, 0);
        FixedWidthImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        FixedWidthImporterTests.whenGetIntegerOption("limit", this.options, -1);
        FixedWidthImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)reader);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)3);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)1)).cells.size(), (int)3);
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(0)), (String)"NDB_No");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(1)), (String)"Shrt_Desc");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(1)).getCellValue(2)), (String)"Water");
        Assert.assertEquals((int)((Row)this.project.rows.get((int)2)).cells.size(), (int)3);
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(2)).getCellValue(0)), (String)"TooSho");
        Assert.assertEquals((String)((String)((Row)this.project.rows.get(2)).getCellValue(1)), (String)"rt");
        Assert.assertNull((Object)((Row)this.project.rows.get(2)).getCellValue(2));
    }
}

