/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.JsonImporter;
import com.google.refine.importers.tree.ImportColumnGroup;
import com.google.refine.importers.tree.TreeImportingParserBase;
import com.google.refine.importers.tree.TreeReader;
import com.google.refine.importing.ImportingJob;
import com.google.refine.model.Cell;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class JsonImporterTests
extends ImporterTest {
    ByteArrayInputStream inputStream = null;
    JsonImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void setUp(Method method) {
        super.setUp();
        this.SUT = new JsonImporter();
        this.logger.debug("About to run test method: " + method.getName());
    }

    @AfterMethod
    public void tearDown(ITestResult result) {
        this.logger.debug("Finished test method: " + result.getMethod().getMethodName());
        this.SUT = null;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream = null;
        }
        super.tearDown();
    }

    @Test
    public void canParseSample() {
        this.RunTest(JsonImporterTests.getSample());
        JsonImporterTests.assertProjectCreated(this.project, 4, 6);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Author 1, The");
    }

    @Test
    public void canThrowError() {
        String errJSON = JsonImporterTests.getSampleWithError();
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, new LinkedList(), "text/json");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)path, (String)"_");
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        JSONUtilities.safePut((ObjectNode)options, (String)"trimStrings", (boolean)false);
        JSONUtilities.safePut((ObjectNode)options, (String)"storeEmptyStrings", (boolean)true);
        JSONUtilities.safePut((ObjectNode)options, (String)"guessCellValueTypes", (boolean)false);
        try {
            this.inputStream = new ByteArrayInputStream(errJSON.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            Assert.fail();
        }
        ImportColumnGroup rootColumnGroup = new ImportColumnGroup();
        ArrayList exceptions = new ArrayList();
        this.SUT.parseOneFile(this.project, this.metadata, this.job, "file-source", (InputStream)this.inputStream, rootColumnGroup, -1, options, exceptions);
        Assert.assertFalse((boolean)exceptions.isEmpty());
        Assert.assertEquals((String)"Unexpected character (';' (code 59)): was expecting comma to separate Object entries", (String)((Exception)exceptions.get(0)).getMessage());
    }

    @Test
    public void trimLeadingTrailingWhitespaceOnTrimStrings() {
        String ScraperwikiOutput = "[\n{\n        \"school\": \"  University of Cambridge  \",\n        \"name\": \"          Amy Zhang                   \",\n        \"student-faculty-score\": \"100\",\n        \"intl-student-score\": \"95\"\n    }\n]\n";
        this.RunTest(ScraperwikiOutput, true);
        JsonImporterTests.assertProjectCreated(this.project, 4, 1);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)0).value, (Object)"University of Cambridge");
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Amy Zhang");
    }

    @Test
    public void doesNotTrimLeadingTrailingWhitespaceOnNoTrimStrings() {
        String ScraperwikiOutput = "[\n{\n        \"school\": \"  University of Cambridge  \",\n        \"name\": \"          Amy Zhang                   \",\n        \"student-faculty-score\": \"100\",\n        \"intl-student-score\": \"95\"\n    }\n]\n";
        this.RunTest(ScraperwikiOutput);
        JsonImporterTests.assertProjectCreated(this.project, 4, 1);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)0).value, (Object)"  University of Cambridge  ");
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"          Amy Zhang                   ");
    }

    @Test
    public void canParseSampleWithDuplicateNestedElements() {
        this.RunTest(JsonImporterTests.getSampleWithDuplicateNestedElements());
        JsonImporterTests.assertProjectCreated(this.project, 4, 12);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)4);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Author 1, The");
        Assert.assertEquals((Object)((Row)this.project.rows.get((int)1)).getCell((int)1).value, (Object)"Author 1, Another");
    }

    @Test
    public void testCanParseLineBreak() {
        this.RunTest(JsonImporterTests.getSampleWithLineBreak());
        JsonImporterTests.assertProjectCreated(this.project, 4, 6);
        Row row = (Row)this.project.rows.get(3);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)4);
        Assert.assertNotNull((Object)row.getCell(1));
        Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"With line\n break");
    }

    @Test
    public void testElementsWithVaryingStructure() {
        this.RunTest(JsonImporterTests.getSampleWithVaryingStructure());
        JsonImporterTests.assertProjectCreated(this.project, 5, 6);
        Assert.assertEquals((String)this.project.columnModel.getColumnByCellIndex(4).getName(), (String)"_ - genre");
        Row row0 = (Row)this.project.rows.get(0);
        Assert.assertNotNull((Object)row0);
        Assert.assertEquals((int)row0.cells.size(), (int)4);
        Row row5 = (Row)this.project.rows.get(5);
        Assert.assertNotNull((Object)row5);
        Assert.assertEquals((int)row5.cells.size(), (int)5);
    }

    @Test
    public void testElementWithNestedTree() {
        this.RunTest(JsonImporterTests.getSampleWithTreeStructure());
        JsonImporterTests.assertProjectCreated(this.project, 5, 6);
        Assert.assertEquals((int)this.project.columnModel.columnGroups.size(), (int)1);
        Assert.assertEquals((int)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).keyColumnIndex, (int)3);
        Assert.assertEquals((int)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).startColumnIndex, (int)3);
        Assert.assertNull((Object)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).parentGroup);
        Assert.assertEquals((int)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).subgroups.size(), (int)0);
        Assert.assertEquals((int)((ColumnGroup)this.project.columnModel.columnGroups.get((int)0)).columnSpan, (int)2);
    }

    @Test
    public void testElementWithMqlReadOutput() {
        String mqlOutput = "{\"code\":\"/api/status/ok\",\"result\":[{\"armed_force\":{\"id\":\"/en/wehrmacht\"},\"id\":\"/en/afrika_korps\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/en/sacred_band_of_thebes\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/en/british_army\"},\"id\":\"/en/british_16_air_assault_brigade\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/en/british_army\"},\"id\":\"/en/pathfinder_platoon\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0ch7qgz\"},\"id\":\"/en/sacred_band\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/en/polish_navy\"},\"id\":\"/en/3rd_ship_flotilla\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0c0kxn9\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0c0kxq9\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0c0kxqh\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0c0kxqp\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0c0kxqw\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0c1wxl3\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0c1wxlp\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0ck96kz\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0cm3j23\",\"type\":\"/military/military_unit\"},{\"armed_force\":{\"id\":\"/m/0chtrwn\"},\"id\":\"/m/0cw8hb4\",\"type\":\"/military/military_unit\"}],\"status\":\"200 OK\",\"transaction_id\":\"cache;cache01.p01.sjc1:8101;2010-10-04T15:04:33Z;0007\"}";
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, new LinkedList(), "text/json");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        path.add("_");
        path.add("result");
        path.add("_");
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        this.RunTest(mqlOutput, options);
        JsonImporterTests.assertProjectCreated(this.project, 3, 16);
    }

    @Test
    public void testJSONMinimumArray() {
        String ScraperwikiOutput = "[\n{\n        \"school\": \"University of Cambridge\\n                            United Kingdom\",\n        \"student-faculty-score\": \"100\",\n        \"intl-student-score\": \"95\",\n        \"intl-faculty-score\": \"96\",\n        \"rank\": \"#1\",\n        \"peer-review-score\": \"100\",\n        \"emp-review-score\": \"100\",\n        \"score\": \"100.0\",\n        \"citations-score\": \"93\"\n    },\n    {\n        \"school\": \"Harvard University\\n                            United States\",\n        \"student-faculty-score\": \"97\",\n        \"intl-student-score\": \"87\",\n        \"intl-faculty-score\": \"71\",\n        \"rank\": \"#2\",\n        \"peer-review-score\": \"100\",\n        \"emp-review-score\": \"100\",\n        \"score\": \"99.2\",\n        \"citations-score\": \"100\"\n    }\n]\n";
        this.RunTest(ScraperwikiOutput);
        JsonImporterTests.assertProjectCreated(this.project, 9, 2);
    }

    @Test
    public void EnsureJSONParserHandlesgetLocalNameCorrectly() throws Exception {
        String sampleJson = "{\"field\":\"value\"}";
        String sampleJson2 = "{\"field\":{}}";
        String sampleJson3 = "{\"field\":[{},{}]}";
        JsonImporter.JSONTreeReader parser = new JsonImporter.JSONTreeReader((InputStream)new ByteArrayInputStream(sampleJson.getBytes("UTF-8")));
        TreeReader.Token token = TreeReader.Token.Ignorable;
        int i = 0;
        try {
            while (token != null && (token = parser.next()) != null) {
                if (++i != 3) continue;
                Assert.assertEquals((Object)TreeReader.Token.Value, (Object)token);
                Assert.assertEquals((String)"field", (String)parser.getFieldName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        parser = new JsonImporter.JSONTreeReader((InputStream)new ByteArrayInputStream(sampleJson2.getBytes("UTF-8")));
        token = TreeReader.Token.Ignorable;
        i = 0;
        try {
            while (token != null && (token = parser.next()) != null) {
                if (++i != 3) continue;
                Assert.assertEquals((Object)TreeReader.Token.StartEntity, (Object)token);
                Assert.assertEquals((String)parser.getFieldName(), (String)"field");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        parser = new JsonImporter.JSONTreeReader((InputStream)new ByteArrayInputStream(sampleJson3.getBytes("UTF-8")));
        token = TreeReader.Token.Ignorable;
        i = 0;
        try {
            while (token != null && (token = parser.next()) != null) {
                if (++i == 3) {
                    Assert.assertEquals((Object)token, (Object)TreeReader.Token.StartEntity);
                    Assert.assertEquals((String)parser.getFieldName(), (String)"field");
                }
                if (i == 4) {
                    Assert.assertEquals((Object)token, (Object)TreeReader.Token.StartEntity);
                    Assert.assertEquals((String)parser.getFieldName(), (String)"_");
                }
                if (i != 6) continue;
                Assert.assertEquals((Object)token, (Object)TreeReader.Token.StartEntity);
                Assert.assertEquals((String)parser.getFieldName(), (String)"_");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testCanParseTab() throws Exception {
        String sampleJson = "{\"\tfield\":\t\"\tvalue\"}";
        JsonImporter.JSONTreeReader parser = new JsonImporter.JSONTreeReader((InputStream)new ByteArrayInputStream(sampleJson.getBytes("UTF-8")));
        TreeReader.Token token = TreeReader.Token.Ignorable;
        int i = 0;
        try {
            while (token != null && (token = parser.next()) != null) {
                if (++i != 3) continue;
                Assert.assertEquals((Object)TreeReader.Token.Value, (Object)token);
                Assert.assertEquals((String)"\tfield", (String)parser.getFieldName());
                Assert.assertEquals((String)"\tvalue", (String)parser.getFieldValue());
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void testJsonDatatypes() {
        this.RunTest(JsonImporterTests.getSampleWithDataTypes());
        JsonImporterTests.assertProjectCreated(this.project, 2, 21, 4);
        Assert.assertEquals((String)this.project.columnModel.getColumnByCellIndex(0).getName(), (String)"_ - id");
        Assert.assertEquals((String)this.project.columnModel.getColumnByCellIndex(1).getName(), (String)"_ - cell - cell");
        Row row = (Row)this.project.rows.get(8);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)"");
        row = (Row)this.project.rows.get(12);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertNull((Object)((Cell)row.cells.get((int)1)).value);
        row = (Row)this.project.rows.get(13);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)Boolean.TRUE);
        row = (Row)this.project.rows.get(14);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)Boolean.FALSE);
        row = (Row)this.project.rows.get(15);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)0L);
        row = (Row)this.project.rows.get(16);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)1L);
        row = (Row)this.project.rows.get(17);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)Double.parseDouble("-2.1"));
        row = (Row)this.project.rows.get(18);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)0.23);
        row = (Row)this.project.rows.get(19);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)-0.24);
        row = (Row)this.project.rows.get(20);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((int)row.cells.size(), (int)2);
        Assert.assertFalse((boolean)Double.isNaN((Double)((Cell)row.cells.get((int)1)).value));
        Assert.assertEquals((Object)((Cell)row.cells.get((int)1)).value, (Object)3.14E100);
    }

    @Test
    public void testComplexJsonStructure() throws IOException {
        String fileName = "grid_small.json";
        this.RunComplexJSONTest(this.getComplexJSON(fileName));
        this.logger.debug("************************ columnu number:" + this.project.columnModel.columns.size() + ". \tcolumn groups number:" + this.project.columnModel.columnGroups.size() + ".\trow number:" + this.project.rows.size() + ".\trecord number:" + this.project.recordModel.getRecordCount());
        JsonImporterTests.assertProjectCreated(this.project, 63, 63, 8);
    }

    @Test
    public void testAddFileColumn() throws Exception {
        String FILE = "json-sample-format-1.json";
        String filename = ClassLoader.getSystemResource("json-sample-format-1.json").getPath();
        FileUtils.copyFile((File)new File(filename), (File)new File(this.job.getRawDataDir(), "json-sample-format-1.json"));
        ArrayList<ObjectNode> fileRecords = new ArrayList<ObjectNode>();
        fileRecords.add(ParsingUtilities.evaluateJsonStringToObjectNode((String)String.format("{\"location\": \"%s\",\"fileName\": \"%s\"}", "json-sample-format-1.json", "json-sample-format-1.json")));
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, new LinkedList(), "text/json");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)path, (String)"_");
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        JSONUtilities.safePut((ObjectNode)options, (String)"trimStrings", (boolean)false);
        JSONUtilities.safePut((ObjectNode)options, (String)"storeEmptyStrings", (boolean)true);
        JSONUtilities.safePut((ObjectNode)options, (String)"guessCellValueTypes", (boolean)false);
        JSONUtilities.safePut((ObjectNode)options, (String)"includeFileSources", (boolean)true);
        ArrayList exceptions = new ArrayList();
        this.SUT.parse(this.project, this.metadata, this.job, fileRecords, "text/json", -1, options, exceptions);
        Assert.assertNotNull((Object)this.project.columnModel.getColumnByName("File"));
        Assert.assertEquals((Object)((Row)this.project.rows.get((int)0)).getCell((int)0).value, (Object)"json-sample-format-1.json");
    }

    private static String getTypicalElement(int id) {
        return "{ \"id\" : " + id + ",\"author\" : \"Author " + id + ", The\",\"title\" : \"Book title " + id + "\",\"publish_date\" : \"2010-05-26\"}";
    }

    private static String getElementWithDuplicateSubElement(int id) {
        return "{ \"id\" : " + id + ",\"authors\":[{\"name\" : \"Author " + id + ", The\"},{\"name\" : \"Author " + id + ", Another\"}],\"title\" : \"Book title " + id + "\",\"publish_date\" : \"2010-05-26\"}";
    }

    static String getSample() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 1; i < 7; ++i) {
            sb.append(JsonImporterTests.getTypicalElement(i));
            if (i >= 6) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static ObjectNode getOptions(ImportingJob job, TreeImportingParserBase parser, String pathSelector, boolean trimStrings) {
        ObjectNode options = parser.createParserUIInitializationData(job, new LinkedList(), "text/json");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)path, (String)"_");
        JSONUtilities.append((ArrayNode)path, (String)pathSelector);
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        JSONUtilities.safePut((ObjectNode)options, (String)"trimStrings", (boolean)trimStrings);
        JSONUtilities.safePut((ObjectNode)options, (String)"storeEmptyStrings", (boolean)true);
        JSONUtilities.safePut((ObjectNode)options, (String)"guessCellValueTypes", (boolean)false);
        return options;
    }

    private static String getSampleWithDuplicateNestedElements() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 1; i < 7; ++i) {
            sb.append(JsonImporterTests.getElementWithDuplicateSubElement(i));
            if (i >= 6) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String getSampleWithLineBreak() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 1; i < 4; ++i) {
            sb.append(JsonImporterTests.getTypicalElement(i));
            sb.append(",");
        }
        sb.append("{\"id\" : 4,\"author\" : \"With line\\n break\",\"title\" : \"Book title 4\",\"publish_date\" : \"2010-05-26\"},");
        sb.append(JsonImporterTests.getTypicalElement(5));
        sb.append(",");
        sb.append(JsonImporterTests.getTypicalElement(6));
        sb.append("]");
        return sb.toString();
    }

    private static String getSampleWithVaryingStructure() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 1; i < 6; ++i) {
            sb.append(JsonImporterTests.getTypicalElement(i));
            sb.append(",");
        }
        sb.append("{\"id\" : 6,\"author\" : \"Author 6, The\",\"title\" : \"Book title 6\",\"genre\" : \"New element not seen in other records\",\"publish_date\" : \"2010-05-26\"}");
        sb.append("]");
        return sb.toString();
    }

    private static String getSampleWithTreeStructure() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 1; i < 7; ++i) {
            sb.append("{\"id\" : " + i + ",\"author\" : {\"author-name\" : \"Author " + i + ", The\",\"author-dob\" : \"1950-0" + i + "-15\"},\"title\" : \"Book title " + i + "\",\"publish_date\" : \"2010-05-26\"}");
            if (i >= 6) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String getSampleWithDataTypes() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 1;
        sb.append("{\"id\":" + i++ + ",\"cell\":[\"39766\",\"T1009\",\"foo\",\"DEU\",\"19\",\"01:49\"]},\n");
        sb.append("{\"id\":" + i++ + ",\"cell\":[\"39766\",\"T1009\",\"\",\"DEU\",\"19\",\"01:49\"]},\n");
        sb.append("{\"id\":null,\"cell\":[null,true,false,0,1,-2.1,0.23,-0.24,3.14e100]}\n");
        sb.append("]");
        return sb.toString();
    }

    private static String getSampleWithError() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("{\"id\":\"\n\";");
        sb.append("]");
        return sb.toString();
    }

    private void RunTest(String testString) {
        this.RunTest(testString, JsonImporterTests.getOptions(this.job, (TreeImportingParserBase)this.SUT, "_", false));
    }

    private void RunComplexJSONTest(String testString) {
        this.RunTest(testString, JsonImporterTests.getOptions(this.job, (TreeImportingParserBase)this.SUT, "institutes", false));
    }

    private void RunTest(String testString, boolean trimStrings) {
        this.RunTest(testString, JsonImporterTests.getOptions(this.job, (TreeImportingParserBase)this.SUT, "_", trimStrings));
    }

    private void RunTest(String testString, ObjectNode options) {
        try {
            this.inputStream = new ByteArrayInputStream(testString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            Assert.fail();
        }
        try {
            this.parseOneInputStream((TreeImportingParserBase)this.SUT, this.inputStream, options);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    private String getComplexJSON(String fileName) throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);
        String content = IOUtils.toString((InputStream)in, (String)"UTF-8");
        return content;
    }
}

