/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importers.OdsImporter;
import com.google.refine.model.Row;
import com.google.refine.util.ParsingUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class OdsImporterTests
extends ImporterTest {
    private static final double EPSILON = 1.0E-7;
    private static final int ROWS = 5;
    private static final int COLUMNS = 8;
    OdsImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new OdsImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        super.tearDown();
    }

    @Test
    public void readOds() throws FileNotFoundException, IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        OdsImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        OdsImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        OdsImporterTests.whenGetIntegerOption("headerLines", this.options, 1);
        OdsImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        OdsImporterTests.whenGetIntegerOption("limit", this.options, 5);
        OdsImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        InputStream stream = ClassLoader.getSystemResourceAsStream("films.ods");
        try {
            this.parseOneFile((ImportingParserBase)this.SUT, stream);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)5);
        Row row = (Row)this.project.rows.get(0);
        Assert.assertEquals((int)row.cells.size(), (int)8);
        Assert.assertEquals((String)((String)row.getCellValue(1)), (String)"2 Days In New York");
        Assert.assertEquals((String)((OffsetDateTime)row.getCellValue(3)).toString().substring(0, 10), (String)"2012-03-28");
        Assert.assertEquals((double)((Number)row.getCellValue(5)).doubleValue(), (double)4.5, (double)1.0E-7);
        Assert.assertFalse((boolean)((Boolean)row.getCellValue(7)));
        Assert.assertTrue((boolean)((Boolean)((Row)this.project.rows.get(1)).getCellValue(7)));
        Assert.assertNull((Object)((String)((Row)this.project.rows.get(2)).getCellValue(2)));
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("ignoreLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("headerLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("skipDataLines");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("limit");
        ((ObjectNode)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)1))).get("storeBlankCellsAsNulls");
    }

    @Test
    public void showErrorDialogWhenWrongFormat() throws FileNotFoundException, IOException {
        ArrayNode sheets = ParsingUtilities.mapper.createArrayNode();
        sheets.add(ParsingUtilities.mapper.readTree("{name: \"file-source#Test Sheet 0\", fileNameAndSheetIndex: \"file-source#0\", rows: 31, selected: true}"));
        OdsImporterTests.whenGetArrayOption("sheets", this.options, sheets);
        OdsImporterTests.whenGetIntegerOption("ignoreLines", this.options, 0);
        OdsImporterTests.whenGetIntegerOption("headerLines", this.options, 1);
        OdsImporterTests.whenGetIntegerOption("skipDataLines", this.options, 0);
        OdsImporterTests.whenGetIntegerOption("limit", this.options, 5);
        OdsImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        InputStream stream = ClassLoader.getSystemResourceAsStream("NoData_NoSpreadsheet.ods");
        try {
            List<Exception> exceptions = this.parseOneFileAndReturnExceptions((ImportingParserBase)this.SUT, stream);
            Assert.assertEquals((int)exceptions.size(), (int)1);
            Exception NPE = exceptions.get(0);
            Assert.assertEquals((String)NPE.getMessage(), (String)"Attempted to parse file as Ods file but failed. No tables found in Ods file. Please validate file format on https://odfvalidator.org/, then try re-uploading the file.");
            assert (NPE.getCause() instanceof NullPointerException);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

