/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importers.WikitextImporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class WikitextImporterTests
extends ImporterTest {
    private WikitextImporter importer = null;
    private Map<String, Recon> mockedRecons = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.importer = new WikitextImporter();
        this.mockedRecons = new HashMap<String, Recon>();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.importer = null;
        super.tearDown();
    }

    @Test
    public void readSimpleData() {
        String input = "\n{|\n|-\n| a || b<br/>2 || c \n|-\n| d || e || f<br>\n|-\n|}\n";
        try {
            this.prepareOptions(0, 0, true, true, null, null);
            this.parse(input);
        }
        catch (Exception e) {
            Assert.fail((String)"Parsing failed", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)2);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"a");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"b\n2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)2)).value, (Object)"f");
    }

    @Test
    public void readTableWithMisplacedHeaders() {
        String input = "\n{|\n|-\n| a || b<br/>2 || c \n|-\n| d\n! e\n| f<br>\n|-\n|}\n";
        try {
            this.prepareOptions(0, 0, true, true, null, null);
            this.parse(input);
        }
        catch (Exception e) {
            Assert.fail((String)"Parsing failed", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)2);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"e");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)2)).value, (Object)"f");
    }

    public void readTableWithLinks() throws Exception {
        String input = "\n{|\n|-\n| [[Europ\u00e4isches Zentrum f\u00fcr die F\u00f6rderung der Berufsbildung|Cedefop]] || Cedefop || http://www.cedefop.europa.eu/\n|-\n| [[Europ\u00e4ische Stiftung zur Verbesserung der Lebens- und Arbeitsbedingungen]] || EUROFOUND || [http://www.eurofound.europa.eu/]\n|-\n| [[Europ\u00e4ische Beobachtungsstelle f\u00fcr Drogen und Drogensucht]] || EMCDDA || [http://www.emcdda.europa.eu/ europa.eu]\n|-\n|}\n";
        try (MockWebServer server = new MockWebServer();){
            server.start();
            String jsonResponse = "{\"q0\":[{\"id\":\"Q1377256\",\"name\":\"Europ\u00e4ische Beobachtungsstelle f\u00fcr Drogen und Drogensucht\"}],\"q1\":[{\"id\":\"Q1377549\",\"name\":\"European Foundation for the Improvement of Living and Working Conditions\"}],\"q2\":[{\"id\":\"Q1377256\",\"name\":\"European Monitoring Centre for Drugs and Drug Addiction\"}]}";
            server.enqueue(new MockResponse().setBody(jsonResponse));
            try {
                this.prepareOptions(0, 0, true, true, "https://de.wikipedia.org/wiki/", server.url("endpoint").url().toString());
                this.parse(input);
            }
            catch (Exception e) {
                Assert.fail((String)"Parsing failed", (Throwable)e);
            }
            Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
            Assert.assertEquals((int)this.project.rows.size(), (int)3);
            Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
            Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"Cedefop");
            Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).recon, null);
            Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)0)).value, (Object)"Europ\u00e4ische Beobachtungsstelle f\u00fcr Drogen und Drogensucht");
            Assert.assertEquals((String)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)0)).recon.getBestCandidate().id, (String)"Q1377256");
            Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)2)).value, (Object)"http://www.eurofound.europa.eu/");
            Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)2)).value, (Object)"http://www.emcdda.europa.eu/");
        }
    }

    @Test
    public void readStyledTableWithHeader() {
        String input = "\n==Agenturen==\n{| class=\"wikitable sortable\"\n! style=\"text-align:left; width: 60em\" | Offizieller Name\n! style=\"text-align:left; width: 9em\" | Abk\u00fcrzung\n! style=\"text-align:left; width: 6em\" | Website\n! style=\"text-align:left; width: 15em\" | Standort\n! style=\"text-align:left; width: 18em\" | Staat\n! style=\"text-align:left; width: 6em\" | Gr\u00fcndung\n! style=\"text-align:left; width: 50em\" | Anmerkungen\n|-\n| [[Europ\u00e4isches Zentrum f\u00fcr die F\u00f6rderung der Berufsbildung]] || '''Cedefop''' || [http://www.cedefop.europa.eu/] || [[Thessaloniki]] || {{Griechenland}} || 1975 ||\n|-\n| [[Europ\u00e4ische Stiftung zur Verbesserung der Lebens- und Arbeitsbedingungen]] || ''EUROFOUND'' || [http://www.eurofound.europa.eu/] || [[Dublin]] || {{Irland}} || 1975 ||\n|-\n| [[Europ\u00e4ische Beobachtungsstelle f\u00fcr Drogen und Drogensucht]] || EMCDDA || [http://www.emcdda.europa.eu/] || [[Lissabon]] || {{Portugal}} || 1993 ||\n|-\n|}\n";
        try {
            this.prepareOptions(-1, 1, true, true, null, null);
            this.parse(input);
        }
        catch (Exception e) {
            Assert.fail((String)"Parsing failed", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)7);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"Europ\u00e4isches Zentrum f\u00fcr die F\u00f6rderung der Berufsbildung");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"Cedefop");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"EUROFOUND");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"Offizieller Name");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(6)).getName(), (String)"Anmerkungen");
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)7);
    }

    @Test
    public void readTableWithSpanningCells() {
        String input = "{| class=\"wikitable\"\n!colspan=\"6\"|Shopping List\n|-\n|Bread & Butter\n|Pie\n|Buns\n|rowspan=\"2\"|Danish\n|colspan=\"2\"|Croissant\n|-\n|Cheese\n|colspan=\"2\"|Ice cream\n|Butter\n|Yogurt\n|}\n";
        try {
            this.prepareOptions(-1, 1, true, true, null, null);
            this.parse(input);
        }
        catch (Exception e) {
            Assert.fail((String)"Parsing failed", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)6);
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(2));
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(3));
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)4)).value, (Object)"Butter");
    }

    @Test
    public void readTableWithReferences() {
        String input = "{|\n! price\n! fruit\n! merchant\n|-\n| a || b <ref name=\"myref\"> See [http://gnu.org here]</ref>  || c <ref name=\"ms\"> or http://microsoft.com/ </ref>\n|-\n| d || e <ref name=\"ms\"/>|| f <ref name=\"myref\" />\n|-\n|}\n";
        try {
            this.prepareOptions(-1, 1, true, true, null, null);
            this.parse(input);
        }
        catch (Exception e) {
            Assert.fail((String)"Parsing failed", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)5);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"b");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"http://gnu.org");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)4)).value, (Object)"http://microsoft.com/");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)4)).value, (Object)"http://gnu.org");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)2)).value, (Object)"http://microsoft.com/");
    }

    @Test
    public void readTableWithReferencesTemplates() {
        String input = "{|\n! price\n! fruit\n! merchant\n|-\n| a || b <ref name=\"myref\">{{cite web|url=http://gnu.org|accessdate=2017-08-30}}</ref>  || c <ref name=\"ms\"> or {{cite journal|url=http://microsoft.com/|title=BLah}} </ref>\n|-\n| d || e <ref name=\"ms\"/>|| f <ref name=\"myref\" />\n|-\n|}\n";
        try {
            this.prepareOptions(-1, 1, true, true, null, null);
            this.parse(input);
        }
        catch (Exception e) {
            Assert.fail((String)"Parsing failed", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)5);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)1)).value, (Object)"b");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value, (Object)"http://gnu.org");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)4)).value, (Object)"http://microsoft.com/");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)4)).value, (Object)"http://gnu.org");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)2)).value, (Object)"http://microsoft.com/");
    }

    @Test
    public void readTableWithTemplates() {
        String input = "\n{|\n|-\n| {{free to read}} || b || c \n|-\n| d\n| [[File:My logo.svg|70px]]\n| f<br>\n|-\n|}\n";
        try {
            this.prepareOptions(0, 0, true, true, null, null);
            this.parse(input);
        }
        catch (Exception e) {
            Assert.fail((String)"Parsing failed", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)3);
        Assert.assertEquals((int)this.project.rows.size(), (int)2);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)3);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"{{free to read}}");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)1)).value, (Object)"[[File:My logo.svg]]");
    }

    private void parse(String wikitext) {
        this.parseOneFile((ImportingParserBase)this.importer, (Reader)new StringReader(wikitext));
    }

    private void prepareOptions(int limit, int headerLines, boolean blankSpanningCells, boolean guessValueType, String wikiUrl, String reconEndpoint) {
        WikitextImporterTests.whenGetIntegerOption("limit", this.options, limit);
        WikitextImporterTests.whenGetIntegerOption("headerLines", this.options, headerLines);
        WikitextImporterTests.whenGetBooleanOption("guessCellValueTypes", this.options, guessValueType);
        WikitextImporterTests.whenGetBooleanOption("blankSpanningCells", this.options, blankSpanningCells);
        WikitextImporterTests.whenGetBooleanOption("storeBlankCellsAsNulls", this.options, true);
        WikitextImporterTests.whenGetBooleanOption("parseReferences", this.options, true);
        WikitextImporterTests.whenGetBooleanOption("includeRawTemplates", this.options, true);
        WikitextImporterTests.whenGetStringOption("wikiUrl", this.options, wikiUrl);
        WikitextImporterTests.whenGetStringOption("reconService", this.options, reconEndpoint);
    }
}

