/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.XmlImporter;
import com.google.refine.importers.tree.TreeImportingParserBase;
import com.google.refine.importing.ImportingJob;
import com.google.refine.model.ColumnGroup;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class XmlImporterTests
extends ImporterTest {
    ByteArrayInputStream inputStream = null;
    XmlImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new XmlImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream = null;
        }
        super.tearDown();
    }

    @Test
    public void canParseSample() {
        this.RunTest(XmlImporterTests.getSample());
        XmlImporterTests.assertProjectCreated(this.project, 4, 6);
        Row row = (Row)this.project.rows.get(0);
        org.testng.Assert.assertNotNull((Object)row);
        org.testng.Assert.assertNotNull((Object)row.getCell(1));
        org.testng.Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Author 1, The");
    }

    @Test
    public void setsProjectMetadata() throws IOException {
        FileUtils.writeStringToFile((File)new File(this.job.getRawDataDir(), "test-file.xml"), (String)XmlImporterTests.getSample(), (String)"UTF-8");
        ArrayList<ObjectNode> fileRecords = new ArrayList<ObjectNode>();
        fileRecords.add(ParsingUtilities.evaluateJsonStringToObjectNode((String)"{\"location\": \"test-file.xml\",\"fileName\": \"test-file.xml\"}"));
        ObjectNode options = ParsingUtilities.mapper.createObjectNode();
        this.SUT.parse(this.project, this.metadata, this.job, fileRecords, "text/json", -1, options, new ArrayList());
        Assert.assertNotNull((Object)this.metadata.getModified());
        Assert.assertNotNull((Object)this.metadata.getCreated());
        Assert.assertNotEquals((long)this.metadata.getImportOptionMetadata().size(), (long)0L);
    }

    @Test
    public void canParseDeeplyNestedSample() {
        this.RunTest(XmlImporterTests.getDeeplyNestedSample(), XmlImporterTests.getNestedOptions(this.job, (TreeImportingParserBase)this.SUT));
        XmlImporterTests.assertProjectCreated(this.project, 4, 6);
        Row row = (Row)this.project.rows.get(0);
        org.testng.Assert.assertNotNull((Object)row);
        org.testng.Assert.assertNotNull((Object)row.getCell(1));
        org.testng.Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Author 1, The");
    }

    @Test
    public void canParseSampleWithMixedElement() {
        this.RunTest(XmlImporterTests.getMixedElementSample(), XmlImporterTests.getNestedOptions(this.job, (TreeImportingParserBase)this.SUT));
        XmlImporterTests.assertProjectCreated(this.project, 4, 6);
        Row row = (Row)this.project.rows.get(0);
        org.testng.Assert.assertNotNull((Object)row);
        org.testng.Assert.assertNotNull((Object)row.getCell(1));
        org.testng.Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Author 1, The");
    }

    @Test
    public void ignoresDtds() {
        this.RunTest(XmlImporterTests.getSampleWithDtd());
        XmlImporterTests.assertProjectCreated(this.project, 4, 6);
        Row row = (Row)this.project.rows.get(0);
        org.testng.Assert.assertNotNull((Object)row);
        org.testng.Assert.assertNotNull((Object)row.getCell(1));
        org.testng.Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Author 1, The");
    }

    @Test
    public void canParseSampleWithDuplicateNestedElements() {
        this.RunTest(XmlImporterTests.getSampleWithDuplicateNestedElements());
        XmlImporterTests.assertProjectCreated(this.project, 4, 12);
        Row row = (Row)this.project.rows.get(0);
        org.testng.Assert.assertNotNull((Object)row);
        org.testng.Assert.assertEquals((int)row.cells.size(), (int)4);
        org.testng.Assert.assertNotNull((Object)row.getCell(1));
        org.testng.Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"Author 1, The");
        org.testng.Assert.assertEquals((Object)((Row)this.project.rows.get((int)1)).getCell((int)1).value, (Object)"Author 1, Another");
    }

    @Test
    public void testCanParseLineBreak() {
        this.RunTest(XmlImporterTests.getSampleWithLineBreak());
        XmlImporterTests.assertProjectCreated(this.project, 4, 6);
        Row row = (Row)this.project.rows.get(3);
        org.testng.Assert.assertNotNull((Object)row);
        org.testng.Assert.assertEquals((int)row.cells.size(), (int)4);
        org.testng.Assert.assertNotNull((Object)row.getCell(1));
        org.testng.Assert.assertEquals((Object)row.getCell((int)1).value, (Object)"With line\n break");
    }

    @Test
    public void testElementsWithVaryingStructure() {
        this.RunTest(XmlImporterTests.getSampleWithVaryingStructure());
        XmlImporterTests.assertProjectCreated(this.project, 5, 6);
        org.testng.Assert.assertEquals((String)this.project.columnModel.getColumnByCellIndex(4).getName(), (String)"book - genre");
        Row row0 = (Row)this.project.rows.get(0);
        org.testng.Assert.assertNotNull((Object)row0);
        org.testng.Assert.assertEquals((int)row0.cells.size(), (int)4);
        Row row5 = (Row)this.project.rows.get(5);
        org.testng.Assert.assertNotNull((Object)row5);
        org.testng.Assert.assertEquals((int)row5.cells.size(), (int)5);
    }

    @Test
    public void testElementWithNestedTree() {
        this.RunTest(XmlImporterTests.getSampleWithTreeStructure());
        XmlImporterTests.assertProjectCreated(this.project, 5, 6);
        org.testng.Assert.assertEquals((int)this.project.columnModel.columnGroups.size(), (int)1);
        ColumnGroup cg0 = (ColumnGroup)this.project.columnModel.columnGroups.get(0);
        org.testng.Assert.assertEquals((int)cg0.keyColumnIndex, (int)1);
        org.testng.Assert.assertEquals((int)cg0.startColumnIndex, (int)1);
        org.testng.Assert.assertNull((Object)cg0.parentGroup);
        org.testng.Assert.assertEquals((int)cg0.subgroups.size(), (int)0);
        org.testng.Assert.assertEquals((int)cg0.columnSpan, (int)2);
    }

    @Test
    public void testAddFileColumn() throws Exception {
        String FILE = "xml-sample-format-1.xml";
        String filename = ClassLoader.getSystemResource("xml-sample-format-1.xml").getPath();
        FileUtils.copyFile((File)new File(filename), (File)new File(this.job.getRawDataDir(), "xml-sample-format-1.xml"));
        ArrayList<ObjectNode> fileRecords = new ArrayList<ObjectNode>();
        fileRecords.add(ParsingUtilities.evaluateJsonStringToObjectNode((String)String.format("{\"location\": \"%s\",\"fileName\": \"%s\"}", "xml-sample-format-1.xml", "xml-sample-format-1.xml")));
        ObjectNode options = this.SUT.createParserUIInitializationData(this.job, new LinkedList(), "text/json");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)path, (String)"library");
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        JSONUtilities.safePut((ObjectNode)options, (String)"trimStrings", (boolean)false);
        JSONUtilities.safePut((ObjectNode)options, (String)"storeEmptyStrings", (boolean)true);
        JSONUtilities.safePut((ObjectNode)options, (String)"guessCellValueTypes", (boolean)false);
        JSONUtilities.safePut((ObjectNode)options, (String)"includeFileSources", (boolean)true);
        ArrayList exceptions = new ArrayList();
        this.SUT.parse(this.project, this.metadata, this.job, fileRecords, "text/json", -1, options, exceptions);
        org.testng.Assert.assertNotNull((Object)this.project.columnModel.getColumnByName("File"));
        org.testng.Assert.assertEquals((Object)((Row)this.project.rows.get((int)0)).getCell((int)0).value, (Object)"xml-sample-format-1.xml");
    }

    public static String getTypicalElement(int id) {
        return "<book id=\"" + id + "\"><author>Author " + id + ", The</author><title>Book title " + id + "</title><publish_date>2010-05-26</publish_date></book>";
    }

    public static String getElementWithDuplicateSubElement(int id) {
        return "<book id=\"" + id + "\"><authors><author>Author " + id + ", The</author><author>Author " + id + ", Another</author></authors><title>Book title " + id + "</title><publish_date>2010-05-26</publish_date></book>";
    }

    public static String getSample() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?><library>");
        for (int i = 1; i < 7; ++i) {
            sb.append(XmlImporterTests.getTypicalElement(i));
        }
        sb.append("</library>");
        return sb.toString();
    }

    public static String getSampleWithDtd() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<!DOCTYPE library [\n<!ENTITY % asd SYSTEM \"http://domain.does.not.exist:4444/ext.dtd\">\n%asd;\n%c;\n]><library>");
        for (int i = 1; i < 7; ++i) {
            sb.append(XmlImporterTests.getTypicalElement(i));
        }
        sb.append("</library>");
        return sb.toString();
    }

    public static ObjectNode getOptions(ImportingJob job, TreeImportingParserBase parser) {
        ObjectNode options = parser.createParserUIInitializationData(job, Collections.emptyList(), "text/xml");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)path, (String)"library");
        JSONUtilities.append((ArrayNode)path, (String)"book");
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        return options;
    }

    public static ObjectNode getNestedOptions(ImportingJob job, TreeImportingParserBase parser) {
        ObjectNode options = parser.createParserUIInitializationData(job, Collections.emptyList(), "text/xml");
        ArrayNode path = ParsingUtilities.mapper.createArrayNode();
        JSONUtilities.append((ArrayNode)path, (String)"nest");
        JSONUtilities.append((ArrayNode)path, (String)"nest2");
        JSONUtilities.append((ArrayNode)path, (String)"library");
        JSONUtilities.append((ArrayNode)path, (String)"book");
        JSONUtilities.safePut((ObjectNode)options, (String)"recordPath", (JsonNode)path);
        return options;
    }

    public static String getDeeplyNestedSample() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?><nest><nest2><library>");
        for (int i = 1; i < 7; ++i) {
            sb.append(XmlImporterTests.getTypicalElement(i));
        }
        sb.append("</library></nest2>");
        sb.append("<anElement>asdf</anElement></nest>");
        return sb.toString();
    }

    public static String getMixedElementSample() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?><nest>");
        sb.append("somemixeduptext");
        sb.append("<nest2><library>");
        for (int i = 1; i < 7; ++i) {
            sb.append(XmlImporterTests.getTypicalElement(i));
        }
        sb.append("</library></nest2>");
        sb.append("<anElement>asdf</anElement></nest>");
        return sb.toString();
    }

    public static String getSampleWithDuplicateNestedElements() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?><library>");
        for (int i = 1; i < 7; ++i) {
            sb.append(XmlImporterTests.getElementWithDuplicateSubElement(i));
        }
        sb.append("</library>");
        return sb.toString();
    }

    public static String getSampleWithLineBreak() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?><library>");
        for (int i = 1; i < 4; ++i) {
            sb.append(XmlImporterTests.getTypicalElement(i));
        }
        sb.append("<book id=\"4\"><author>With line\n break</author><title>Book title 4</title><publish_date>2010-05-26</publish_date></book>");
        sb.append(XmlImporterTests.getTypicalElement(5));
        sb.append(XmlImporterTests.getTypicalElement(6));
        sb.append("</library>");
        return sb.toString();
    }

    public static String getSampleWithVaryingStructure() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?><library>");
        for (int i = 1; i < 6; ++i) {
            sb.append(XmlImporterTests.getTypicalElement(i));
        }
        sb.append("<book id=\"6\"><author>Author 6, The</author><title>Book title 6</title><genre>New element not seen in other records</genre><publish_date>2010-05-26</publish_date></book>");
        sb.append("</library>");
        return sb.toString();
    }

    public static String getSampleWithTreeStructure() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\"?><library>");
        for (int i = 1; i < 7; ++i) {
            sb.append("<book id=\"" + i + "\"><author><author-name>Author " + i + ", The</author-name><author-dob>1950-0" + i + "-15</author-dob></author><title>Book title " + i + "</title><publish_date>2010-05-26</publish_date></book>");
        }
        sb.append("</library>");
        return sb.toString();
    }

    private void RunTest(String testString) {
        this.RunTest(testString, XmlImporterTests.getOptions(this.job, (TreeImportingParserBase)this.SUT));
    }

    private void RunTest(String testString, ObjectNode objectNode) {
        try {
            this.inputStream = new ByteArrayInputStream(testString.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            org.testng.Assert.fail();
        }
        try {
            this.parseOneFile((TreeImportingParserBase)this.SUT, this.inputStream, objectNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            org.testng.Assert.fail();
        }
    }

    @Override
    protected void parseOneFile(TreeImportingParserBase parser, InputStream inputStream, ObjectNode options) {
        this.parseOneInputStream(parser, inputStream, options);
    }
}

