/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.io;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.ProjectMetadata;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class ProjectMetadataTests {
    private String jsonSaveMode = null;
    private String jsonNonSaveMode = null;

    @BeforeSuite
    public void setUpJson() throws IOException {
        InputStream f = ProjectMetadataTests.class.getClassLoader().getResourceAsStream("example_project_metadata.json");
        this.jsonNonSaveMode = IOUtils.toString((InputStream)f);
        f = ProjectMetadataTests.class.getClassLoader().getResourceAsStream("example_project_metadata_save_mode.json");
        this.jsonSaveMode = IOUtils.toString((InputStream)f);
    }

    @Test
    public void serializeProjectMetadata() throws IOException {
        ProjectMetadata metadata = (ProjectMetadata)ParsingUtilities.mapper.readValue(this.jsonSaveMode, ProjectMetadata.class);
        TestUtils.isSerializedTo(metadata, this.jsonNonSaveMode);
        TestUtils.isSerializedTo(metadata, this.jsonSaveMode, true);
    }

    @Test
    public void serializeProjectMetadataInDifferentTimezone() throws JsonParseException, JsonMappingException, IOException {
        TimeZone originalTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("JST"));
            ProjectMetadata metadata = (ProjectMetadata)ParsingUtilities.mapper.readValue(this.jsonSaveMode, ProjectMetadata.class);
            TestUtils.isSerializedTo(metadata, this.jsonNonSaveMode);
            TestUtils.isSerializedTo(metadata, this.jsonSaveMode, true);
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
        }
    }
}

