/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.google.refine.RefineTest;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.Row;
import com.google.refine.util.Pool;
import com.google.refine.util.TestUtils;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RowTests
extends RefineTest {
    StringWriter writer;
    Project project;
    Properties options;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.writer = new StringWriter();
        this.project = new Project();
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.writer = null;
        this.project = null;
        this.options = null;
    }

    @Test
    public void emptyRow() {
        Row row = new Row(5);
        Assert.assertTrue((boolean)row.isEmpty());
    }

    @Test
    public void notEmptyRow() {
        Row row = new Row(1);
        row.setCell(0, new Cell((Serializable)((Object)"I'm not empty"), null));
        Assert.assertFalse((boolean)row.isEmpty());
    }

    @Test
    public void duplicateRow() {
        Row row = new Row(5);
        row.flagged = true;
        Row duplicateRow = row.dup();
        Assert.assertTrue((boolean)duplicateRow.flagged);
    }

    @Test
    public void saveRow() {
        Row row = new Row(5);
        row.setCell(0, new Cell((Serializable)((Object)"I'm not empty"), null));
        row.save((Writer)this.writer, this.options);
        TestUtils.assertEqualsAsJson("{\"flagged\":false,\"starred\":false,\"cells\":[{\"v\":\"I'm not empty\"}]}", this.writer.getBuffer().toString());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void saveRowWithRecordIndex() {
        Row row = new Row(5);
        row.setCell(0, new Cell((Serializable)((Object)"I'm not empty"), null));
        Mockito.when((Object)this.options.containsKey("rowIndex")).thenReturn((Object)true);
        Mockito.when((Object)this.options.get("rowIndex")).thenReturn((Object)0);
        Mockito.when((Object)this.options.containsKey("recordIndex")).thenReturn((Object)true);
        Mockito.when((Object)this.options.get("recordIndex")).thenReturn((Object)1);
        row.save((Writer)this.writer, this.options);
    }

    @Test
    public void serializeRowTest() throws Exception {
        String reconJson = "{\"id\":1533649346002675326,\"judgmentHistoryEntry\":1530278634724,\"service\":\"https://tools.wmflabs.org/openrefine-wikidata/en/api\",\"identifierSpace\":\"http://www.wikidata.org/entity/\",\"schemaSpace\":\"http://www.wikidata.org/prop/direct/\",\"j\":\"matched\",\"m\":{\"id\":\"Q551479\",\"name\":\"La Monnaie\",\"score\":100,\"types\":[\"Q153562\"]},\"c\":[{\"id\":\"Q551479\",\"name\":\"La Monnaie\",\"score\":100,\"types\":[\"Q153562\"]}],\"f\":[false,false,34,0],\"judgmentAction\":\"auto\",\"judgmentBatchSize\":1,\"matchRank\":0}";
        Pool pool = (Pool)Mockito.mock(Pool.class);
        Recon recon = Recon.loadStreaming((String)reconJson);
        Mockito.when((Object)pool.getRecon("1533649346002675326")).thenReturn((Object)recon);
        String json = "{\"flagged\":false,\"starred\":false,\"cells\":[    {\"v\":\"http://www.wikidata.org/entity/Q41522540\",\"r\":\"1533649346002675326\"},    {\"v\":\"0000-0002-5022-0488\"},    null,    {\"v\":\"\"}]}";
        Row row = Row.load((String)json, (Pool)pool);
        TestUtils.isSerializedTo(row, json);
    }

    @Test
    public void toStringTest() {
        Row row = new Row(5);
        row.setCell(0, new Cell((Serializable)Integer.valueOf(1), null));
        row.setCell(1, new Cell((Serializable)Integer.valueOf(2), null));
        row.setCell(2, new Cell((Serializable)Integer.valueOf(3), null));
        row.setCell(3, new Cell((Serializable)Integer.valueOf(4), null));
        row.setCell(4, new Cell((Serializable)Integer.valueOf(5), null));
        Assert.assertEquals((String)row.toString(), (String)"1,2,3,4,5,");
    }

    @Test
    public void blankCell() {
        Row row = new Row(5);
        Assert.assertTrue((boolean)row.isCellBlank(0));
    }

    @Test
    public void nonBlankCell() {
        Row row = new Row(5);
        row.setCell(0, new Cell((Serializable)((Object)"I'm not empty"), null));
        Assert.assertFalse((boolean)row.isCellBlank(0));
        row.setCell(3, new Cell((Serializable)((Object)"I'm not empty"), null));
        Assert.assertFalse((boolean)row.isCellBlank(3));
    }

    @Test
    public void getFlaggedField() {
        Row row = new Row(5);
        row.flagged = true;
        Assert.assertTrue((boolean)((Boolean)row.getField("flagged", this.options)));
    }

    @Test
    public void getStarredField() {
        Row row = new Row(5);
        row.starred = true;
        Assert.assertTrue((boolean)((Boolean)row.getField("starred", this.options)));
    }
}

