/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.cell;

import com.google.refine.ProjectManager;
import com.google.refine.RefineTest;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.cell.TransposeColumnsIntoRowsOperation;
import com.google.refine.process.Process;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.Serializable;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class TransposeColumnsIntoRowsOperationTest
extends RefineTest {
    Project project = null;

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"transpose-columns-into-rows", TransposeColumnsIntoRowsOperation.class);
    }

    @BeforeMethod
    public void setUp() {
        this.project = this.createProject(new String[]{"num1", "num2"}, new Serializable[][]{{"2", "3"}, {"6", null}, {"5", "9"}});
    }

    @AfterMethod
    public void tearDown() {
        ProjectManager.singleton.deleteProject(this.project.id);
    }

    @Test
    public void testCreateHistoryEntry_transposeIntoOneColumn_removeRowForNullOrEmptyCell() throws Exception {
        TransposeColumnsIntoRowsOperation op = new TransposeColumnsIntoRowsOperation("num1", -1, true, false, "a", true, ":");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"num1:2", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value);
        Assert.assertEquals((Object)"num2:3", (Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value);
        Assert.assertEquals((Object)"num1:6", (Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)0)).value);
        Assert.assertEquals((Object)"num1:5", (Object)((Cell)((Row)this.project.rows.get((int)3)).cells.get((int)0)).value);
        Assert.assertEquals((Object)"num2:9", (Object)((Cell)((Row)this.project.rows.get((int)4)).cells.get((int)0)).value);
    }
}

