/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.row;

import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.browsing.RowVisitor;
import com.google.refine.expr.functions.FacetCount;
import com.google.refine.history.HistoryEntry;
import com.google.refine.model.Cell;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.row.RowRemovalOperation;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RowRemovalOperationTests
extends RefineTest {
    static final String ENGINE_JSON_DUPLICATES = "{\"facets\":[{\"type\":\"list\",\"name\":\"facet A\",\"columnName\":\"Column A\",\"expression\":\"facetCount(value, 'value', 'Column A') > 1\",\"omitBlank\":false,\"omitError\":false,\"selection\":[{\"v\":{\"v\":true,\"l\":\"true\"}}],\"selectBlank\":false,\"selectError\":false,\"invert\":false}],\"mode\":\"row-based\"}}";
    Project project;
    Properties options;
    EngineConfig engine_config;
    Engine engine;
    Properties bindings;

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"row-removal", RowRemovalOperation.class);
    }

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void serializeRowRemovalOperation() throws IOException {
        String json = "{\"op\":\"core/row-removal\",\"description\":\"Remove rows\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[]}}";
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(json, RowRemovalOperation.class), json);
    }

    @BeforeMethod
    public void SetUp() throws IOException, ModelException {
        this.project = this.createProjectWithColumns("RowRemovalOperationTests", "Column A");
        this.engine = new Engine(this.project);
        this.engine_config = EngineConfig.reconstruct((String)ENGINE_JSON_DUPLICATES);
        this.engine.initializeFromConfig(this.engine_config);
        this.engine.setMode(Engine.Mode.RowBased);
        this.bindings = new Properties();
        this.bindings.put("project", this.project);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.project = null;
        this.engine = null;
        this.bindings = null;
    }

    private void checkRowCounts(int all, int filtered) {
        this.engine.getAllRows().accept(this.project, (RowVisitor)new CountVerificationRowVisitor(all));
        this.engine.getAllFilteredRows().accept(this.project, (RowVisitor)new CountVerificationRowVisitor(filtered));
        FacetCount fc = new FacetCount();
        Integer count = (Integer)fc.call(this.bindings, new Object[]{"a", "value", "Column A"});
        Assert.assertEquals((int)count, (int)filtered);
    }

    @Test
    public void testIssue567() throws Exception {
        for (int i = 0; i < 5; ++i) {
            Row row = new Row(5);
            row.setCell(0, new Cell((Serializable)((Object)(i < 4 ? "a" : "b")), null));
            this.project.rows.add(row);
        }
        this.checkRowCounts(5, 4);
        RowRemovalOperation op = new RowRemovalOperation(this.engine_config);
        HistoryEntry historyEntry = op.createProcess(this.project, this.options).performImmediate();
        this.checkRowCounts(1, 0);
        historyEntry.revert(this.project);
        this.checkRowCounts(5, 4);
    }

    class CountVerificationRowVisitor
    implements RowVisitor {
        private int count = 0;
        private int target;

        private CountVerificationRowVisitor(int targetCount) {
            this.target = targetCount;
        }

        public boolean visit(Project project, int rowIndex, Row row) {
            ++this.count;
            return false;
        }

        public void start(Project project) {
            this.count = 0;
        }

        public void end(Project project) {
            Assert.assertEquals((int)this.count, (int)this.target);
        }
    }
}

