/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.refine.util.ParsingUtilities;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.testng.Assert;

public class TestUtils {
    static ObjectMapper mapper = new ObjectMapper();

    public static File createTempDirectory(String name) throws IOException {
        File dir = File.createTempFile(name, "");
        dir.delete();
        dir.mkdir();
        return dir;
    }

    public static void assertEqualsAsJson(String actual, String expected) {
        try {
            JsonNode jsonA = (JsonNode)mapper.readValue(expected, JsonNode.class);
            JsonNode jsonB = (JsonNode)mapper.readValue(actual, JsonNode.class);
            if (!jsonA.equals((Object)jsonB)) {
                TestUtils.jsonDiff(expected, actual);
                Assert.fail((String)"Objects above are not equal as JSON strings.");
            }
        }
        catch (Exception e) {
            Assert.fail((String)("\"" + actual + "\" and \"" + expected + "\" are not equal as JSON strings."));
        }
    }

    public static boolean equalAsJson(String a, String b) {
        try {
            JsonNode jsonA = (JsonNode)mapper.readValue(a, JsonNode.class);
            JsonNode jsonB = (JsonNode)mapper.readValue(b, JsonNode.class);
            return jsonA == null && jsonB == null || jsonA.equals((Object)jsonB);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void isSerializedTo(Object o, String targetJson, boolean saveMode) {
        try {
            ObjectWriter writer = null;
            writer = saveMode ? ParsingUtilities.saveWriter : ParsingUtilities.defaultWriter;
            String jacksonJson = writer.writeValueAsString(o);
            TestUtils.assertEqualsAsJson(jacksonJson, targetJson);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            Assert.fail((String)"jackson serialization failed");
        }
    }

    public static void isSerializedTo(Object o, String targetJson) {
        TestUtils.isSerializedTo(o, targetJson, false);
    }

    public static void jsonDiff(String a, String b) throws JsonParseException, JsonMappingException {
        ObjectMapper myMapper = mapper.copy().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.INDENT_OUTPUT, true);
        try {
            JsonNode nodeA = (JsonNode)myMapper.readValue(a, JsonNode.class);
            JsonNode nodeB = (JsonNode)myMapper.readValue(b, JsonNode.class);
            String prettyA = myMapper.writeValueAsString(myMapper.treeToValue((TreeNode)nodeA, Object.class));
            String prettyB = myMapper.writeValueAsString(myMapper.treeToValue((TreeNode)nodeB, Object.class));
            LineNumberReader readerA = new LineNumberReader(new StringReader(prettyA));
            int maxLength = 0;
            String line = readerA.readLine();
            while (line != null) {
                if (line.length() > maxLength) {
                    maxLength = line.length();
                }
                line = readerA.readLine();
            }
            readerA = new LineNumberReader(new StringReader(prettyA));
            LineNumberReader readerB = new LineNumberReader(new StringReader(prettyB));
            StringWriter writer = new StringWriter();
            String lineA = readerA.readLine();
            String lineB = readerB.readLine();
            while (lineA != null || lineB != null) {
                if (lineA == null) {
                    lineA = "";
                }
                if (lineB == null) {
                    lineB = "";
                }
                String paddedLineA = lineA + new String(new char[maxLength + 2 - lineA.length()]).replace("\u0000", " ");
                writer.write(paddedLineA);
                writer.write(lineB + "\n");
                lineA = readerA.readLine();
                lineB = readerB.readLine();
            }
            System.out.print(writer.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void assertEqualAsQueries(String expectedQuery, String actualQuery) throws UnsupportedEncodingException {
        String[] actualResponse = URLDecoder.decode(actualQuery, "UTF-8").split("=");
        String[] expected = URLDecoder.decode(expectedQuery, "UTF-8").split("=");
        Assert.assertEquals((String)actualResponse[0], (String)expected[0]);
        TestUtils.assertEqualsAsJson(actualResponse[1], expected[1]);
    }

    static {
        mapper = mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        mapper = mapper.enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION});
        mapper = mapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
    }
}

