/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.browsing.facets;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.facets.Facet;
import com.google.refine.browsing.facets.ListFacet;
import com.google.refine.model.Project;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import org.testng.annotations.Test;

public class ListFacetTests
extends RefineTest {
    private static String jsonConfig = "{\"type\":\"list\",\"name\":\"facet A\",\"columnName\":\"Column A\",\"expression\":\"value+\\\"bar\\\"\",\"omitBlank\":false,\"omitError\":false,\"selection\":[{\"v\":{\"v\":\"foobar\",\"l\":\"true\"}}],\"selectBlank\":false,\"selectError\":false,\"invert\":false}";
    private static String jsonFacetError = "{\"name\":\"facet A\",\"expression\":\"value+\\\"bar\\\"\",\"columnName\":\"Column A\",\"invert\":false,\"error\":\"No column named Column A\"}";
    private static String jsonFacet = "{\"name\":\"facet A\",\"expression\":\"value+\\\"bar\\\"\",\"columnName\":\"Column A\",\"invert\":false,\"choices\":[     {\"v\":{\"v\":\"barbar\",\"l\":\"barbar\"},\"c\":1,\"s\":false},     {\"v\":{\"v\":\"foobar\",\"l\":\"foobar\"},\"c\":1,\"s\":true}]}";
    private static String selectedEmptyChoiceFacet = "{\"name\":\"facet A\",\"expression\":\"value+\\\"bar\\\"\",\"columnName\":\"Column A\",\"invert\":false,\"choices\":[    {\"v\":{\"v\":\"abar\",\"l\":\"abar\"},\"c\":1,\"s\":false},    {\"v\":{\"v\":\"cbar\",\"l\":\"cbar\"},\"c\":1,\"s\":false},    {\"v\":{\"v\":\"ebar\",\"l\":\"ebar\"},\"c\":1,\"s\":false},    {\"v\":{\"v\":\"foobar\",\"l\":\"true\"},\"c\":0,\"s\":true}]}";

    @Test
    public void serializeListFacetConfig() throws JsonParseException, JsonMappingException, IOException {
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        TestUtils.isSerializedTo(facetConfig, jsonConfig);
    }

    @Test
    public void serializeListFacet() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createProject(new String[]{"Column A"}, new Serializable[][]{{"foo"}, {"bar"}});
        Engine engine = new Engine(project);
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        Facet facet = facetConfig.apply(project);
        facet.computeChoices(project, engine.getAllFilteredRows());
        ObjectNode actual = (ObjectNode)ParsingUtilities.mapper.valueToTree((Object)facet);
        ArrayList<JsonNode> choicesList = new ArrayList<JsonNode>();
        ((JsonNode)actual.findValues("choices").get(0)).forEach(choicesList::add);
        choicesList.sort(Comparator.comparing(JsonNode::toString));
        actual.replace("choices", (JsonNode)ParsingUtilities.mapper.createArrayNode().addAll(choicesList));
        TestUtils.assertEqualsAsJson(actual.toString(), jsonFacet);
    }

    @Test
    public void serializeListFacetWithError() throws JsonParseException, JsonMappingException, IOException {
        Project project = this.createProject(new String[]{"other column"}, new Serializable[][]{{"foo"}, {"bar"}});
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        Facet facet = facetConfig.apply(project);
        TestUtils.isSerializedTo(facet, jsonFacetError);
    }

    @Test
    public void testSelectedEmptyChoice() throws IOException {
        Project project = this.createProject(new String[]{"Column A"}, new Serializable[][]{{"a"}, {"c"}, {"e"}});
        Engine engine = new Engine(project);
        ListFacet.ListFacetConfig facetConfig = (ListFacet.ListFacetConfig)ParsingUtilities.mapper.readValue(jsonConfig, ListFacet.ListFacetConfig.class);
        Facet facet = facetConfig.apply(project);
        facet.computeChoices(project, engine.getAllFilteredRows());
        ObjectNode actual = (ObjectNode)ParsingUtilities.mapper.valueToTree((Object)facet);
        ArrayList<JsonNode> choicesList = new ArrayList<JsonNode>();
        ((JsonNode)actual.findValues("choices").get(0)).forEach(choicesList::add);
        choicesList.sort(Comparator.comparing(n -> n.get("v").toString()));
        actual.replace("choices", (JsonNode)ParsingUtilities.mapper.createArrayNode().addAll(choicesList));
        TestUtils.assertEqualsAsJson(actual.toString(), selectedEmptyChoiceFacet);
    }
}

