/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands;

import com.google.refine.commands.CSRFTokenFactory;
import java.time.Instant;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CSRFTokenFactoryTests {
    @Test
    public void testGenerateValidToken() {
        CSRFTokenFactory factory = new CSRFTokenFactory(10L, 25);
        String token = factory.getFreshToken();
        Assert.assertTrue((boolean)factory.validToken(token));
        Assert.assertEquals((int)25, (int)token.length());
    }

    @Test
    public void testInvalidToken() {
        CSRFTokenFactory factory = new CSRFTokenFactory(10L, 25);
        Assert.assertFalse((boolean)factory.validToken("bogusToken"));
    }

    @Test
    public void testOldToken() {
        CSRFTokenFactoryStub stub = new CSRFTokenFactoryStub(10L, 25);
        String token = stub.getFreshToken();
        stub.tamperWithToken(token, Instant.now().minusSeconds(100L));
        Assert.assertFalse((boolean)stub.validToken(token));
    }

    static class CSRFTokenFactoryStub
    extends CSRFTokenFactory {
        public CSRFTokenFactoryStub(long timeToLive, int tokenLength) {
            super(timeToLive, tokenLength);
        }

        public void tamperWithToken(String token, Instant newGenerationTime) {
            this.tokenCache.asMap().put(token, newGenerationTime);
        }
    }
}

