/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.commands.Command;
import com.google.refine.commands.GetCSRFTokenCommand;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GetCSRFTokenCommandTest {
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected StringWriter writer = null;
    protected Command command = null;

    @BeforeMethod
    public void setUp() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.command = new GetCSRFTokenCommand();
        this.writer = new StringWriter();
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(this.writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetToken() throws JsonParseException, JsonMappingException, IOException, ServletException {
        this.command.doGet(this.request, this.response);
        ObjectNode result = (ObjectNode)ParsingUtilities.mapper.readValue(this.writer.toString(), ObjectNode.class);
        String token = result.get("token").asText();
        Assert.assertTrue((boolean)Command.csrfFactory.validToken(token));
    }
}

