/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.lang;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.RefineServlet;
import com.google.refine.commands.CommandTestBase;
import com.google.refine.commands.lang.LoadLanguageCommand;
import com.google.refine.io.FileProjectManager;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LoadLanguageCommandTests
extends CommandTestBase {
    @BeforeMethod
    public void setUpCommand() throws IOException {
        FileProjectManager.initialize((File)TestUtils.createTempDirectory("openrefine-test-workspace-dir"));
        this.command = new LoadLanguageCommand();
        ButterflyModule coreModule = (ButterflyModule)Mockito.mock(ButterflyModule.class);
        Mockito.when((Object)coreModule.getName()).thenReturn((Object)"core");
        Mockito.when((Object)coreModule.getPath()).thenReturn((Object)new File("webapp/modules/core"));
        RefineServlet servlet = (RefineServlet)Mockito.mock(RefineServlet.class);
        Mockito.when((Object)servlet.getModule("core")).thenReturn((Object)coreModule);
        this.command.init(servlet);
    }

    @Test
    public void testLoadSingleLanguage() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("module")).thenReturn((Object)"core");
        Mockito.when((Object)this.request.getParameterValues("lang")).thenReturn((Object)new String[]{"en_GB"});
        this.command.doPost(this.request, this.response);
        JsonNode response = (JsonNode)ParsingUtilities.mapper.readValue(this.writer.toString(), JsonNode.class);
        Assert.assertTrue((boolean)response.has("dictionary"));
        Assert.assertEquals((String)response.get("lang").asText(), (String)"en_GB");
    }

    public void testLoadMultiLanguages() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("module")).thenReturn((Object)"core");
        Mockito.when((Object)this.request.getParameterValues("lang")).thenReturn((Object)new String[]{"ja", "it", "es", "de"});
        this.command.doPost(this.request, this.response);
        JsonNode response = (JsonNode)ParsingUtilities.mapper.readValue(this.writer.toString(), JsonNode.class);
        Assert.assertTrue((boolean)response.has("dictionary"));
        Assert.assertEquals((String)response.get("lang").asText(), (String)"ja");
    }

    @Test
    public void testLoadUnknownLanguage() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("module")).thenReturn((Object)"core");
        Mockito.when((Object)this.request.getParameterValues("lang")).thenReturn((Object)new String[]{"foobar"});
        this.command.doPost(this.request, this.response);
        JsonNode response = (JsonNode)ParsingUtilities.mapper.readValue(this.writer.toString(), JsonNode.class);
        Assert.assertTrue((boolean)response.has("dictionary"));
        Assert.assertEquals((String)response.get("lang").asText(), (String)"en");
    }

    @Test
    public void testLoadNoLanguage() throws JsonParseException, JsonMappingException, IOException, ServletException {
        Mockito.when((Object)this.request.getParameter("module")).thenReturn((Object)"core");
        Mockito.when((Object)this.request.getParameterValues("lang")).thenReturn((Object)new String[]{""});
        this.command.doPost(this.request, this.response);
        JsonNode response = (JsonNode)ParsingUtilities.mapper.readValue(this.writer.toString(), JsonNode.class);
        Assert.assertTrue((boolean)response.has("dictionary"));
        Assert.assertEquals((String)response.get("lang").asText(), (String)"en");
    }

    @Test
    public void testLoadNullLanguage() throws JsonParseException, JsonMappingException, IOException, ServletException {
        Mockito.when((Object)this.request.getParameter("module")).thenReturn((Object)"core");
        Mockito.when((Object)this.request.getParameterValues("lang")).thenReturn(null);
        this.command.doPost(this.request, this.response);
        JsonNode response = (JsonNode)ParsingUtilities.mapper.readValue(this.writer.toString(), JsonNode.class);
        Assert.assertTrue((boolean)response.has("dictionary"));
        Assert.assertEquals((String)response.get("lang").asText(), (String)"en");
    }

    @Test
    public void testLoadLanguageWithDirectorySlip() throws JsonParseException, JsonMappingException, IOException, ServletException {
        Mockito.when((Object)this.request.getParameter("module")).thenReturn((Object)"core");
        Mockito.when((Object)this.request.getParameterValues("lang")).thenReturn((Object)new String[]{"../../../secrets"});
        this.command.doPost(this.request, this.response);
        JsonNode response = (JsonNode)ParsingUtilities.mapper.readValue(this.writer.toString(), JsonNode.class);
        Assert.assertTrue((boolean)response.has("dictionary"));
        Assert.assertEquals((String)response.get("lang").asText(), (String)"en");
    }

    @Test
    public void testLanguageFallback() throws JsonParseException, JsonMappingException, IOException {
        String fallbackJson = "{\"foo\":\"hello\",\"bar\":\"world\"}";
        String preferredJson = "{\"foo\":\"hallo\"}";
        String expectedJson = "{\"foo\":\"hallo\",\"bar\":\"world\"}";
        ObjectNode fallback = (ObjectNode)ParsingUtilities.mapper.readValue(fallbackJson, ObjectNode.class);
        ObjectNode preferred = (ObjectNode)ParsingUtilities.mapper.readValue(preferredJson, ObjectNode.class);
        ObjectNode expected = (ObjectNode)ParsingUtilities.mapper.readValue(expectedJson, ObjectNode.class);
        ObjectNode merged = LoadLanguageCommand.mergeLanguages((ObjectNode)preferred, (ObjectNode)fallback);
        Assert.assertEquals((Iterable)merged, (Iterable)expected);
    }
}

