/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.project;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.commands.Command;
import com.google.refine.commands.CommandTestBase;
import com.google.refine.commands.project.SetProjectTagsCommand;
import com.google.refine.model.Project;
import com.google.refine.model.ProjectStub;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetProjectTagsCommandTests
extends CommandTestBase {
    private static long PROJECT_ID = 1234L;
    private String[] TAGS = new String[]{"tag1", "tag2"};
    ProjectManager projectManager = null;
    Project project = null;
    PrintWriter pw = null;

    @BeforeMethod
    public void setUpCommand() throws JsonProcessingException {
        this.command = new SetProjectTagsCommand();
        this.pw = new PrintWriter(this.writer);
        ProjectMetadata metadata = new ProjectMetadata();
        metadata.setUserMetadata((ArrayNode)ParsingUtilities.mapper.readTree("[ {name: \"clientID\", display: true} ]"));
        metadata.setTags(this.TAGS);
        ProjectManager.singleton = this.projectManager = new ProjectManagerStub();
        this.project = new ProjectStub(PROJECT_ID);
        ProjectManager.singleton.registerProject(this.project, metadata);
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(PROJECT_ID));
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)this.pw);
        }
        catch (IOException e1) {
            Assert.fail();
        }
    }

    @Test
    public void setProjectTagsTest() {
        Assert.assertEquals((Object[])ProjectManager.singleton.getAllProjectsTags().keySet().stream().sorted().toArray(String[]::new), (Object[])this.TAGS);
        Mockito.when((Object)this.request.getParameter("old")).thenReturn((Object)String.join((CharSequence)",", this.TAGS));
        Mockito.when((Object)this.request.getParameter("new")).thenReturn((Object)"a b c");
        try {
            this.command.doPost(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("csrf_token");
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("project");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader("Content-Type", "application/json");
        try {
            ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getWriter();
        }
        catch (IOException e) {
            Assert.fail();
        }
        TestUtils.assertEqualsAsJson(this.writer.toString(), "{\"code\":\"ok\"}");
        Object[] tags = this.project.getMetadata().getTags();
        Assert.assertEquals((int)tags.length, (int)3);
        Arrays.sort(tags);
        Assert.assertEquals((String)tags[1], (String)"b");
        Map tagCounts = ProjectManager.singleton.getAllProjectsTags();
        Assert.assertEquals((int)tagCounts.size(), (int)3);
        Assert.assertEquals((String)((String[])ProjectManager.singleton.getAllProjectsTags().keySet().stream().sorted().toArray(String[]::new))[1], (String)"b");
        this.projectManager.deleteProject(PROJECT_ID);
    }

    @Test
    public void testCSRFProtection() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn(null);
        this.command.doPost(this.request, this.response);
        this.assertCSRFCheckFailed();
    }
}

