/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.util.TestUtils;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class EvalErrorTests
extends RefineTest {
    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void serializeEvalError() {
        EvalError e = new EvalError("This is a critical error");
        TestUtils.isSerializedTo(e, "{\"type\":\"error\",\"message\":\"This is a critical error\"}");
    }

    @Test
    public void testInnerHtml() {
        Assert.assertTrue((boolean)(EvalErrorTests.invoke("innerHtml", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(EvalErrorTests.invoke("innerHtml", "test") instanceof EvalError));
        EvalError evalError = (EvalError)EvalErrorTests.invoke("innerHtml", "test");
        Assert.assertEquals((String)evalError.toString(), (String)"innerHtml() cannot work with this 'string'. The first parameter is not an HTML Element. Please first use parseHtml(string) and select(query) prior to using this function");
    }

    @Test
    public void testWholeText() {
        Assert.assertTrue((boolean)(EvalErrorTests.invoke("wholeText", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(EvalErrorTests.invoke("wholeText", "test") instanceof EvalError));
        EvalError evalError = (EvalError)EvalErrorTests.invoke("wholeText", "test");
        Assert.assertEquals((String)evalError.toString(), (String)"wholeText() cannot work with this 'string' and failed as the first parameter is not an XML or HTML Element.  Please first use parseXml() or parseHtml() and select(query) prior to using this function");
    }

    @Test
    public void testXmlText() {
        Assert.assertTrue((boolean)(EvalErrorTests.invoke("xmlText", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(EvalErrorTests.invoke("xmlText", "test") instanceof EvalError));
        EvalError evalError = (EvalError)EvalErrorTests.invoke("xmlText", "test");
        Assert.assertEquals((String)evalError.toString(), (String)"xmlText() cannot work with this 'string' and failed as the first parameter is not an XML or HTML Element.  Please first use parseXml() or parseHtml() and select(query) prior to using this function");
    }
}

