/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.date;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class IncTests
extends RefineTest {
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HH:mm:ss.SSSSSSSSSX");

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testInc() {
        OffsetDateTime source = OffsetDateTime.parse("20180510-23:55:44.000789000Z", this.formatter);
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "hours") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "hours"), (Object)source.plus(2L, ChronoUnit.HOURS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "hour"), (Object)source.plus(2L, ChronoUnit.HOURS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "h"), (Object)source.plus(2L, ChronoUnit.HOURS));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "year") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "years"), (Object)source.plus(2L, ChronoUnit.YEARS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "year"), (Object)source.plus(2L, ChronoUnit.YEARS));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "months") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "months"), (Object)source.plus(2L, ChronoUnit.MONTHS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "month"), (Object)source.plus(2L, ChronoUnit.MONTHS));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "minutes") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "minutes"), (Object)source.plus(2L, ChronoUnit.MINUTES));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "minute"), (Object)source.plus(2L, ChronoUnit.MINUTES));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "min"), (Object)source.plus(2L, ChronoUnit.MINUTES));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "weeks") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "weeks"), (Object)source.plus(2L, ChronoUnit.WEEKS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "week"), (Object)source.plus(2L, ChronoUnit.WEEKS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "w"), (Object)source.plus(2L, ChronoUnit.WEEKS));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "seconds") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "seconds"), (Object)source.plus(2L, ChronoUnit.SECONDS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "sec"), (Object)source.plus(2L, ChronoUnit.SECONDS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "s"), (Object)source.plus(2L, ChronoUnit.SECONDS));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "milliseconds") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "milliseconds"), (Object)source.plus(2L, ChronoUnit.MILLIS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "ms"), (Object)source.plus(2L, ChronoUnit.MILLIS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "S"), (Object)source.plus(2L, ChronoUnit.MILLIS));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 2, "nanos") instanceof OffsetDateTime));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "nanos"), (Object)source.plus(2L, ChronoUnit.NANOS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "nano"), (Object)source.plus(2L, ChronoUnit.NANOS));
        Assert.assertEquals((Object)IncTests.invoke("inc", source, 2, "n"), (Object)source.plus(2L, ChronoUnit.NANOS));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source, 99) instanceof EvalError));
        Assert.assertTrue((boolean)(IncTests.invoke("inc", source.toInstant().toEpochMilli(), 99, "h") instanceof EvalError));
    }
}

