/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RandomNumberTest
extends RefineTest {
    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void setUp() throws Exception {
        bindings = new Properties();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        bindings = null;
    }

    @Test
    public void testCall() {
        Object result1 = RandomNumberTest.invoke("random", new Object[0]);
        Assert.assertTrue((result1 instanceof Double && this.inRange(0.0, 1.0, result1) ? 1 : 0) != 0);
        Object result2 = RandomNumberTest.invoke("random", 3, 4);
        Assert.assertTrue((boolean)this.inRange(3.0, 4.0, result2));
        Object result3 = RandomNumberTest.invoke("randomNumber", 3, 4.4);
        Assert.assertTrue((boolean)this.inRange(3.0, 4.4, result3));
        Object result4 = RandomNumberTest.invoke("random", 2.3, 4);
        Assert.assertTrue((result4 instanceof Double && this.inRange(2.3, 4.0, result4) ? 1 : 0) != 0);
        Object result5 = RandomNumberTest.invoke("randomNumber", 3.2, 12.2);
        Assert.assertTrue((result5 instanceof Double && this.inRange(3.2, 12.2, result5) ? 1 : 0) != 0);
    }

    public boolean inRange(double min, double max, Object result) {
        return (Double)result >= min && (Double)result <= max;
    }

    @Test
    public void testCallInvalidParams() {
        Assert.assertTrue((boolean)(RandomNumberTest.invoke("random", 2) instanceof EvalError));
        Assert.assertTrue((boolean)(RandomNumberTest.invoke("random", 3) instanceof EvalError));
        Assert.assertTrue((boolean)(RandomNumberTest.invoke("random", null, null) instanceof EvalError));
        Assert.assertTrue((boolean)(RandomNumberTest.invoke("random", 3, 4, 6, 5) instanceof EvalError));
    }
}

