/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EncodeTest
extends RefineTest {
    @Test
    public void testEncode() {
        String[][] inputs;
        for (String[] input : inputs = new String[][]{{"abc", "base16", "616263"}, {"a\n\r\nb", "base16", "610A0D0A62"}, {"abc", "base32", "MFRGG==="}, {"a\n\r\nb", "base32", "MEFA2CTC"}, {"abc", "base32hex", "C5H66==="}, {"a\n\r\nb", "base32hex", "C450Q2J2"}, {"abc", "base64", "YWJj"}, {"a\n\r\nb", "base64", "YQoNCmI="}, {"abc", "base64url", "YWJj"}, {"a\n\r\nb", "base64url", "YQoNCmI="}}) {
            String string = input[0];
            String encoding = input[1];
            String expected = input[2];
            Assert.assertEquals((Object)EncodeTest.invoke("encode", string, encoding), (Object)expected);
        }
    }

    @Test
    public void testEncodeInvalidParams() {
        Assert.assertTrue((boolean)(EncodeTest.invoke("encode", "abc", "base16", "base32") instanceof EvalError));
        Assert.assertTrue((boolean)(EncodeTest.invoke("encode", "base64") instanceof EvalError));
        Assert.assertTrue((boolean)(EncodeTest.invoke("encode", "abc") instanceof EvalError));
        Assert.assertTrue((boolean)(EncodeTest.invoke("encode", 2, "base16") instanceof EvalError));
        Assert.assertTrue((boolean)(EncodeTest.invoke("encode", "abc", "encoding") instanceof EvalError));
    }
}

