/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TrimTests
extends RefineTest {
    private static String NBSP = "\u00a0";
    private static String ENQUAD = "\u2000";
    private static String EMQUAD = "\u2001";
    private static String ENSPC = "\u2002";
    private static String EMSPC = "\u2003";
    private static String N3PMSPC = "\u2004";
    private static String N4PMSPC = "\u2005";
    private static String N6PMSPC = "\u2006";
    private static String FIGSP = "\u2007";
    private static String PUNCSPC = "\u2008";
    private static String THINSPC = "\u2009";
    private static String HAIRSPC = "\u200a";
    private static String NNBSP = "\u202f";
    private static String MDMMATHSPC = "\u205f";
    private static String IDEOSPC = "\u3000";
    private static String WHITESPACE = NBSP + ENQUAD + ENSPC + EMQUAD + EMSPC + N3PMSPC + N4PMSPC + N6PMSPC + FIGSP + PUNCSPC + THINSPC + HAIRSPC + NNBSP + MDMMATHSPC + IDEOSPC;
    private static String[][] testStrings = new String[][]{{" foo ", "foo"}, {"\tfoo\t", "foo"}, {"\t \t foo \t \t", "foo"}, {"", ""}};

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testInvalidParams() {
        Assert.assertTrue((boolean)(TrimTests.invoke("trim", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(TrimTests.invoke("trim", "one", "two", "three") instanceof EvalError));
        Assert.assertTrue((boolean)(TrimTests.invoke("trim", Long.getLong("1")) instanceof EvalError));
    }

    @Test
    public void testTrim() {
        for (String[] ss : testStrings) {
            Assert.assertEquals((int)ss.length, (int)2, (String)"Invalid test");
            Assert.assertEquals((String)((String)TrimTests.invoke("trim", ss[0])), (String)ss[1], (String)("Trim for string: " + ss + " failed"));
        }
        for (int i = 0; i < WHITESPACE.length(); ++i) {
            String c = WHITESPACE.substring(i, i + 1);
            Assert.assertEquals((String)((String)TrimTests.invoke("trim", c + "foo" + c)), (String)"foo", (String)("Trim for whitespace char: '" + c + "' at index " + i + " failed"));
        }
    }
}

