/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importing;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.ProjectMetadata;
import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.SeparatorBasedImporter;
import com.google.refine.importing.ImportingJob;
import com.google.refine.importing.ImportingManager;
import com.google.refine.importing.ImportingUtilities;
import com.google.refine.model.Column;
import com.google.refine.model.Row;
import com.google.refine.util.JSONUtilities;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.StreamSupport;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.HttpUrl;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.FileSystem;
import org.apache.commons.io.FileUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ImportingUtilitiesTests
extends ImporterTest {
    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
    }

    @Test
    public void createProjectMetadataTest() throws Exception {
        ObjectNode optionObj = ParsingUtilities.evaluateJsonStringToObjectNode((String)"{\"projectName\":\"acme\",\"projectTags\":[],\"created\":\"2017-12-18T13:28:40.659\",\"modified\":\"2017-12-20T09:28:06.654\",\"creator\":\"\",\"contributors\":\"\",\"subject\":\"\",\"description\":\"\",\"rowCount\":50,\"customMetadata\":{}}");
        ProjectMetadata pm = ImportingUtilities.createProjectMetadata((ObjectNode)optionObj);
        Assert.assertEquals((String)pm.getName(), (String)"acme");
        Assert.assertEquals((String)pm.getEncoding(), (String)"UTF-8");
        Assert.assertTrue((pm.getTags().length == 0 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testZipSlip() throws IOException {
        File tempDir = TestUtils.createTempDirectory("openrefine-zip-slip-test");
        ImportingUtilities.allocateFile((File)tempDir, (String)"../../tmp/script.sh");
    }

    @Test
    public void testAllocateFileDeduplication() throws IOException {
        File tempDir = TestUtils.createTempDirectory("openrefine-allocate-file-test");
        File dirA = new File(tempDir, "a");
        dirA.mkdir();
        File conflicting = new File(dirA, "dummy");
        Assert.assertTrue((boolean)conflicting.createNewFile());
        File allocated = ImportingUtilities.allocateFile((File)dirA, (String)".././a/dummy");
        Assert.assertEquals((Object)allocated, (Object)new File(dirA, "dummy-2"));
    }

    @Test
    public void testNormalizePath() {
        String urlPath = "/a/b:c/dummy:test";
        String urlPathFixed = "\\a\\b-c\\dummy-test";
        String result = ImportingUtilities.normalizePath((String)urlPath);
        FileSystem fileSystem = FileSystem.getCurrent();
        if (fileSystem == FileSystem.WINDOWS) {
            Assert.assertEquals((String)urlPathFixed, (String)result);
        } else {
            Assert.assertEquals((String)urlPath, (String)result);
        }
    }

    @Test
    public void testNormalizePathWithDifferentSeparator() {
        String urlPath = "\\a\\b:c\\dummy:test";
        String urlPathFixed = "\\a\\b-c\\dummy-test";
        String result = ImportingUtilities.normalizePath((String)urlPath);
        FileSystem fileSystem = FileSystem.getCurrent();
        if (fileSystem == FileSystem.WINDOWS) {
            Assert.assertEquals((String)urlPathFixed, (String)result);
        } else {
            Assert.assertEquals((String)urlPath, (String)result);
        }
    }

    @Test
    public void testAllocateFileWithIllegalCharInWindows() throws IOException {
        File tempDir = TestUtils.createTempDirectory("openrefine-allocate-file-test");
        File dirA = new File(tempDir, "a");
        Assert.assertTrue((boolean)dirA.mkdir());
        String urlPath = ".././a/b:c/dummy:test";
        String urlPathFixed = ".././a/b-c/dummy-test";
        File allocated = ImportingUtilities.allocateFile((File)dirA, (String)urlPath);
        FileSystem fileSystem = FileSystem.getCurrent();
        if (fileSystem == FileSystem.WINDOWS) {
            Assert.assertEquals((Object)allocated, (Object)new File(dirA, urlPathFixed));
        } else {
            Assert.assertEquals((Object)allocated, (Object)new File(dirA, urlPath));
        }
    }

    @Test
    public void testAllocateFileWithIllegalCharInWindowsDifferentSeparator() throws IOException {
        File tempDir = TestUtils.createTempDirectory("openrefine-allocate-file-test");
        File dirA = new File(tempDir, "a");
        Assert.assertTrue((boolean)dirA.mkdir());
        String urlPath = "..\\.\\a\\b:c\\dummy:test";
        String urlPathFixed = "..\\.\\a\\b-c\\dummy-test";
        File allocated = ImportingUtilities.allocateFile((File)dirA, (String)urlPath);
        FileSystem fileSystem = FileSystem.getCurrent();
        if (fileSystem == FileSystem.WINDOWS) {
            Assert.assertEquals((Object)allocated, (Object)new File(dirA, urlPathFixed));
        } else {
            Assert.assertEquals((Object)allocated, (Object)new File(dirA, urlPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void urlImporting() throws IOException {
        String RESPONSE_BODY = "{code:401,message:Unauthorised}";
        MockWebServer server = new MockWebServer();
        MockResponse mockResponse = new MockResponse();
        mockResponse.setBody(RESPONSE_BODY);
        mockResponse.setResponseCode(401);
        server.start();
        server.enqueue(mockResponse);
        HttpUrl url = server.url("/random");
        String MESSAGE = String.format("HTTP error %d : %s for URL %s", 401, "Client Error", url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        StringBody stringBody = new StringBody(url.toString(), ContentType.MULTIPART_FORM_DATA);
        builder = builder.addPart("download", (ContentBody)stringBody);
        HttpEntity entity = builder.build();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getContentType()).thenReturn((Object)entity.getContentType());
        Mockito.when((Object)req.getParameter("download")).thenReturn((Object)url.toString());
        Mockito.when((Object)req.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)req.getContentLength()).thenReturn((Object)((int)entity.getContentLength()));
        Mockito.when((Object)req.getInputStream()).thenReturn((Object)new MockServletInputStream(is));
        final ImportingJob job = ImportingManager.createJob();
        Properties parameters = ParsingUtilities.parseUrlParameters((HttpServletRequest)req);
        ObjectNode retrievalRecord = ParsingUtilities.mapper.createObjectNode();
        final ObjectNode progress = ParsingUtilities.mapper.createObjectNode();
        try {
            ImportingUtilities.retrieveContentFromPostRequest((HttpServletRequest)req, (Properties)parameters, (File)job.getRawDataDir(), (ObjectNode)retrievalRecord, (ImportingUtilities.Progress)new ImportingUtilities.Progress(){

                public void setProgress(String message, int percent) {
                    if (message != null) {
                        JSONUtilities.safePut((ObjectNode)progress, (String)"message", (String)message);
                    }
                    JSONUtilities.safePut((ObjectNode)progress, (String)"percent", (long)percent);
                }

                public boolean isCanceled() {
                    return job.canceled;
                }
            });
            Assert.fail((String)"No Exception was thrown");
        }
        catch (Exception exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)MESSAGE);
        }
        finally {
            server.close();
        }
    }

    @Test
    public void urlImportingInvalidProtocol() throws IOException {
        String url = "file:///etc/passwd";
        String message = "Unsupported protocol: file";
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        StringBody stringBody = new StringBody(url.toString(), ContentType.MULTIPART_FORM_DATA);
        builder = builder.addPart("download", (ContentBody)stringBody);
        HttpEntity entity = builder.build();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        entity.writeTo((OutputStream)os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getContentType()).thenReturn((Object)entity.getContentType());
        Mockito.when((Object)req.getParameter("download")).thenReturn((Object)url.toString());
        Mockito.when((Object)req.getMethod()).thenReturn((Object)"POST");
        Mockito.when((Object)req.getContentLength()).thenReturn((Object)((int)entity.getContentLength()));
        Mockito.when((Object)req.getInputStream()).thenReturn((Object)new MockServletInputStream(is));
        final ImportingJob job = ImportingManager.createJob();
        Properties parameters = ParsingUtilities.parseUrlParameters((HttpServletRequest)req);
        ObjectNode retrievalRecord = ParsingUtilities.mapper.createObjectNode();
        final ObjectNode progress = ParsingUtilities.mapper.createObjectNode();
        try {
            ImportingUtilities.retrieveContentFromPostRequest((HttpServletRequest)req, (Properties)parameters, (File)job.getRawDataDir(), (ObjectNode)retrievalRecord, (ImportingUtilities.Progress)new ImportingUtilities.Progress(){

                public void setProgress(String message, int percent) {
                    if (message != null) {
                        JSONUtilities.safePut((ObjectNode)progress, (String)"message", (String)message);
                    }
                    JSONUtilities.safePut((ObjectNode)progress, (String)"percent", (long)percent);
                }

                public boolean isCanceled() {
                    return job.canceled;
                }
            });
            Assert.fail((String)"No Exception was thrown");
        }
        catch (Exception exception) {
            Assert.assertEquals((String)exception.getMessage(), (String)message);
        }
    }

    @Test
    public void importArchive() throws IOException {
        String filename = "movies.zip";
        String filepath = ClassLoader.getSystemResource(filename).getPath();
        File tmp = File.createTempFile("openrefine-test-movies", ".zip", this.job.getRawDataDir());
        tmp.deleteOnExit();
        FileUtils.copyFile((File)new File(filepath), (File)tmp);
        ImportingUtilities.Progress dummyProgress = new ImportingUtilities.Progress(){

            public void setProgress(String message, int percent) {
            }

            public boolean isCanceled() {
                return false;
            }
        };
        ArrayNode fileRecords = ParsingUtilities.mapper.createArrayNode();
        ObjectNode fileRecord = ParsingUtilities.mapper.createObjectNode();
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"origin", (String)"upload");
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"declaredEncoding", (String)"UTF-8");
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"declaredMimeType", (String)"application/x-zip-compressed");
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"fileName", (String)filename);
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"location", (String)tmp.getName());
        Assert.assertTrue((boolean)ImportingUtilities.postProcessRetrievedFile((File)this.job.getRawDataDir(), (File)tmp, (ObjectNode)fileRecord, (ArrayNode)fileRecords, (ImportingUtilities.Progress)dummyProgress));
        Assert.assertEquals((int)fileRecords.size(), (int)2);
        Assert.assertEquals((String)fileRecords.get(0).get("fileName").asText(), (String)"movies-condensed.tsv");
        Assert.assertEquals((String)fileRecords.get(0).get("archiveFileName").asText(), (String)"movies.zip");
        Assert.assertEquals((String)fileRecords.get(1).get("fileName").asText(), (String)"movies.tsv");
        ObjectNode options = ParsingUtilities.mapper.createObjectNode();
        JSONUtilities.safePut((ObjectNode)options, (String)"includeArchiveFileName", (boolean)true);
        JSONUtilities.safePut((ObjectNode)options, (String)"includeFileSources", (boolean)true);
        SeparatorBasedImporter parser = new SeparatorBasedImporter();
        ArrayList exceptions = new ArrayList();
        parser.parse(this.project, this.metadata, this.job, JSONUtilities.getObjectList((ArrayNode)fileRecords), "tsv", -1, options, exceptions);
        Assert.assertEquals((int)exceptions.size(), (int)0);
        this.project.update();
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"Archive");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCell(0).getValue(), (Object)"movies.zip");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(1)).getName(), (String)"File");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCell(1).getValue(), (Object)"movies-condensed.tsv");
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(2)).getName(), (String)"name");
        Assert.assertEquals((Object)((Row)this.project.rows.get(0)).getCell(2).getValue(), (Object)"Wayne's World");
        Assert.assertEquals((int)this.project.rows.size(), (int)252);
        ArrayNode importOptionsArray = this.metadata.getImportOptionMetadata();
        Assert.assertEquals((int)importOptionsArray.size(), (int)2);
        ObjectNode importOptions = (ObjectNode)importOptionsArray.get(0);
        Assert.assertEquals((String)importOptions.get("archiveFileName").asText(), (String)"movies.zip");
        Assert.assertEquals((String)importOptions.get("fileSource").asText(), (String)"movies-condensed.tsv");
        Assert.assertTrue((boolean)importOptions.get("includeFileSources").asBoolean());
        Assert.assertTrue((boolean)importOptions.get("includeArchiveFileName").asBoolean());
        importOptions = (ObjectNode)importOptionsArray.get(1);
        Assert.assertEquals((String)importOptions.get("fileSource").asText(), (String)"movies.tsv");
        Assert.assertEquals((String)importOptions.get("archiveFileName").asText(), (String)"movies.zip");
    }

    @Test
    public void importUnsupportedZipFile() throws IOException {
        for (String basename : new String[]{"unsupportedPPMD", "notazip"}) {
            this.testInvalidZipFile(basename);
        }
    }

    private void testInvalidZipFile(String basename) throws IOException {
        String filename = basename + ".zip";
        String filepath = ClassLoader.getSystemResource(filename).getPath();
        File tmp = File.createTempFile("openrefine-test-" + basename, ".zip", this.job.getRawDataDir());
        tmp.deleteOnExit();
        FileUtils.copyFile((File)new File(filepath), (File)tmp);
        ImportingUtilities.Progress dummyProgress = new ImportingUtilities.Progress(){

            public void setProgress(String message, int percent) {
            }

            public boolean isCanceled() {
                return false;
            }
        };
        ArrayNode fileRecords = ParsingUtilities.mapper.createArrayNode();
        ObjectNode fileRecord = ParsingUtilities.mapper.createObjectNode();
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"origin", (String)"upload");
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"declaredEncoding", (String)"UTF-8");
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"declaredMimeType", (String)"application/x-zip-compressed");
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"fileName", (String)filename);
        JSONUtilities.safePut((ObjectNode)fileRecord, (String)"location", (String)tmp.getName());
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Assert.assertThrows((String)("Failed to throw for " + filename), IOException.class, () -> ImportingUtilities.postProcessRetrievedFile((File)this.job.getRawDataDir(), (File)tmp, (ObjectNode)fileRecord, (ArrayNode)fileRecords, (ImportingUtilities.Progress)dummyProgress));
        Assert.assertThrows((String)("Failed to throw for " + filename), FileUploadBase.InvalidContentTypeException.class, () -> ImportingUtilities.retrieveContentFromPostRequest((HttpServletRequest)request, (Properties)new Properties(), (File)this.job.getRawDataDir(), (ObjectNode)fileRecord, (ImportingUtilities.Progress)dummyProgress));
        Assert.assertThrows((String)("Failed to throw for " + filename), IOException.class, () -> ImportingUtilities.loadDataAndPrepareJob((HttpServletRequest)request, (HttpServletResponse)response, (Properties)new Properties(), (ImportingJob)this.job, (ObjectNode)fileRecord));
    }

    @Test
    public void testImportCompressedFiles() throws IOException, URISyntaxException {
        String FILENAME_BASE = "persons";
        int LINES = 4;
        String[] suffixes = new String[]{"", ".csv.gz", ".csv.bz2"};
        InputStreamReader reader = null;
        for (String suffix : suffixes) {
            String filename = "persons" + suffix;
            Path filePath = Paths.get(ClassLoader.getSystemResource(filename).toURI());
            File tmp = File.createTempFile("openrefine-test-persons", suffix, this.job.getRawDataDir());
            tmp.deleteOnExit();
            byte[] contents = Files.readAllBytes(filePath);
            Files.write(tmp.toPath(), contents, new OpenOption[0]);
            Files.write(tmp.toPath(), contents, StandardOpenOption.APPEND);
            InputStream is = ImportingUtilities.tryOpenAsCompressedFile((File)tmp, null, null);
            Assert.assertNotNull((Object)is, (String)("Failed to open compressed file: " + filename));
            reader = new InputStreamReader(is);
            CSVParser records = CSVFormat.DEFAULT.parse((Reader)reader);
            Assert.assertEquals((long)StreamSupport.stream(records.spliterator(), false).count(), (long)8L, (String)("row count mismatch for " + filename));
        }
        reader.close();
    }

    @Test
    public void testIsCompressedFile() throws IOException {
        Object[][] cases;
        for (Object[] test : cases = new Object[][]{{"movies.tsv", false}, {"persons.csv", false}, {"persons.csv.gz", true}, {"persons.csv.bz2", true}, {"unsupportedPPMD.zip", true}}) {
            Assert.assertEquals((Object)ImportingUtilities.isCompressed((File)new File(ClassLoader.getSystemResource((String)test[0]).getFile())), (Object)test[1], (String)("Wrong value for isCompressed of: " + test));
        }
    }

    @Test
    public void testTrailingSpaceInUrl() throws IOException, FileUploadException {
        try (MockWebServer server = new MockWebServer();){
            String url = server.url("input.csv ").toString();
            server.enqueue(new MockResponse().setHttp2ErrorCode(404).setStatus("HTTP/1.1 404 Not Found"));
            String message = String.format("HTTP error %d : %s for URL %s", 404, "Not Found", url.trim());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            StringBody stringBody = new StringBody(url, ContentType.MULTIPART_FORM_DATA);
            builder = builder.addPart("download", (ContentBody)stringBody);
            HttpEntity entity = builder.build();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)req.getContentType()).thenReturn((Object)entity.getContentType());
            Mockito.when((Object)req.getParameter("download")).thenReturn((Object)url);
            Mockito.when((Object)req.getMethod()).thenReturn((Object)"POST");
            Mockito.when((Object)req.getContentLength()).thenReturn((Object)((int)entity.getContentLength()));
            Mockito.when((Object)req.getInputStream()).thenReturn((Object)new MockServletInputStream(is));
            ImportingJob job = ImportingManager.createJob();
            Properties parameters = ParsingUtilities.parseUrlParameters((HttpServletRequest)req);
            ObjectNode retrievalRecord = ParsingUtilities.mapper.createObjectNode();
            ImportingUtilities.Progress dummyProgress = new ImportingUtilities.Progress(){

                public void setProgress(String message, int percent) {
                }

                public boolean isCanceled() {
                    return false;
                }
            };
            try {
                ImportingUtilities.retrieveContentFromPostRequest((HttpServletRequest)req, (Properties)parameters, (File)job.getRawDataDir(), (ObjectNode)retrievalRecord, (ImportingUtilities.Progress)dummyProgress);
                Assert.fail((String)"No Exception was thrown");
            }
            catch (ClientProtocolException exception) {
                Assert.assertEquals((String)exception.getMessage(), (String)message);
            }
        }
    }

    public static class MockServletInputStream
    extends ServletInputStream {
        private final InputStream delegate;

        public MockServletInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }
    }
}

