/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.io;

import com.google.refine.ProjectMetadata;
import com.google.refine.io.FileProjectManager;
import com.google.refine.model.Project;
import com.google.refine.util.GetProjectIDException;
import com.google.refine.util.TestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonObject;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FileProjectManagerTests {
    protected File workspaceDir;
    protected File workspaceFile;

    @BeforeMethod
    public void createDirectory() throws IOException {
        this.workspaceDir = TestUtils.createTempDirectory("openrefine-test-workspace-dir");
        this.workspaceFile = new File(this.workspaceDir, "workspace.json");
    }

    @Test
    public void serializeFileProjectManager() {
        FileProjectManagerStub manager = new FileProjectManagerStub(this.workspaceDir);
        String json = "{\n       \"preferences\" : {\n         \"entries\" : {\n           \"scripting.expressions\" : {\n             \"class\" : \"com.google.refine.preference.TopList\",\n             \"list\" : [ ],\n             \"top\" : 100\n           },\n           \"scripting.starred-expressions\" : {\n             \"class\" : \"com.google.refine.preference.TopList\",\n             \"list\" : [ ],\n             \"top\" : 2147483647\n           }\n         }\n       },\n       \"projectIDs\" : [ 5555 ]\n     }";
        TestUtils.isSerializedTo((Object)manager, json);
    }

    @Test
    public void saveReloadMultinationalCharacter() throws IOException {
        FileProjectManagerStub manager = new FileProjectManagerStub(this.workspaceDir);
        manager.getPreferenceStore().put("testPref", (Object)"Refin\u00e9");
        manager.saveWorkspace();
        manager = new FileProjectManagerStub(this.workspaceDir);
        Assert.assertEquals((Object)manager.getPreferenceStore().get("testPref"), (Object)"Refin\u00e9");
    }

    @Test
    public void deleteProjectAndSaveWorkspace() throws IOException {
        FileProjectManagerStub manager = new FileProjectManagerStub(this.workspaceDir);
        manager.saveWorkspace();
        manager.deleteProject(5555L);
        manager.saveWorkspace();
        FileInputStream inputStream = new FileInputStream(this.workspaceFile);
        JsonObject json = JSON.parse((InputStream)inputStream);
        Assert.assertTrue((boolean)json.get("projectIDs").getAsArray().isEmpty(), (String)"deleted project still in workspace.json");
    }

    @Test
    public void metaFileUpdateTest() throws GetProjectIDException, InterruptedException {
        FileProjectManager manager = new FileProjectManager(this.workspaceDir);
        ProjectMetadata metaA = new ProjectMetadata();
        ProjectMetadata metaB = new ProjectMetadata();
        metaA.setName("A");
        metaB.setName("B");
        manager.registerProject(new Project(), metaA);
        manager.registerProject(new Project(), metaB);
        manager.saveWorkspace();
        long idA = manager.getProjectID("A");
        long idB = manager.getProjectID("B");
        Path pathA = Paths.get(manager.getProjectDir(idA).getAbsolutePath(), "metadata.json");
        Path pathB = Paths.get(manager.getProjectDir(idB).getAbsolutePath(), "metadata.json");
        File metaAFile = pathA.toFile();
        File metaBFile = pathB.toFile();
        long timeBeforeA = metaAFile.lastModified();
        long timeBeforeB = metaBFile.lastModified();
        manager = new FileProjectManager(this.workspaceDir);
        Thread.sleep(1000L);
        manager.getProjectMetadata(idA).setName("ModifiedA");
        manager.saveWorkspace();
        long timeAfterA = metaAFile.lastModified();
        long timeAfterB = metaBFile.lastModified();
        Assert.assertEquals((long)timeBeforeB, (long)timeAfterB, (String)"Unmodified project written when it didn't need to be");
        Assert.assertNotEquals((Object)timeBeforeA, (Object)timeAfterA, (String)"Modified project not written");
        try {
            FileUtils.deleteDirectory((File)metaAFile.getParentFile());
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to delete metadata directory for " + metaAFile));
        }
        manager = new FileProjectManager(this.workspaceDir);
        Assert.assertEquals((long)manager.getProjectID("B"), (long)idB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUntarZipSlip() throws IOException {
        FileProjectManagerStub manager = new FileProjectManagerStub(this.workspaceDir);
        File tempDir = TestUtils.createTempDirectory("openrefine-project-import-zip-slip-test");
        try (InputStream stream = FileProjectManagerTests.class.getClassLoader().getResourceAsStream("zip-slip.tar");){
            File subDir = new File(tempDir, "dest");
            Assert.assertThrows(IllegalArgumentException.class, () -> manager.untar(subDir, stream));
        }
        finally {
            tempDir.delete();
        }
    }

    protected class FileProjectManagerStub
    extends FileProjectManager {
        protected FileProjectManagerStub(File dir) {
            super(dir);
            this._projectsMetadata.put(5555L, (ProjectMetadata)Mockito.mock(ProjectMetadata.class));
        }
    }
}

