/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.google.refine.expr.EvalError;
import com.google.refine.model.Cell;
import com.google.refine.model.Recon;
import com.google.refine.util.Pool;
import com.google.refine.util.TestUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CellTests {
    String reconJson = "{\"id\":1533649346002675326,\"judgmentHistoryEntry\":1530278634724,\"service\":\"https://tools.wmflabs.org/openrefine-wikidata/en/api\",\"identifierSpace\":\"http://www.wikidata.org/entity/\",\"schemaSpace\":\"http://www.wikidata.org/prop/direct/\",\"j\":\"matched\",\"m\":{\"id\":\"Q551479\",\"name\":\"La Monnaie\",\"score\":100,\"types\":[\"Q153562\"]},\"c\":[{\"id\":\"Q551479\",\"name\":\"La Monnaie\",\"score\":100,\"types\":[\"Q153562\"]}],\"f\":[false,false,34,0],\"judgmentAction\":\"auto\",\"judgmentBatchSize\":1,\"matchRank\":0}";
    Pool pool = (Pool)Mockito.mock(Pool.class);
    Recon recon = null;

    @Test
    public void serializeCellWithRecon() throws Exception {
        this.recon = Recon.loadStreaming((String)this.reconJson);
        Mockito.when((Object)this.pool.getRecon("1533649346002675326")).thenReturn((Object)this.recon);
        String json = "{\"v\":\"http://www.wikidata.org/entity/Q41522540\",\"r\":\"1533649346002675326\"}";
        Cell c = Cell.loadStreaming((String)json, (Pool)this.pool);
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeCellWithString() throws Exception {
        String json = "{\"v\":\"0000-0002-5022-0488\"}";
        Cell c = Cell.loadStreaming((String)json, (Pool)this.pool);
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeNullCell() throws Exception {
        String json = "null";
        Cell c = Cell.loadStreaming((String)json, (Pool)this.pool);
        Assert.assertNull((Object)c);
    }

    @Test
    public void serializeEmptyStringCell() throws Exception {
        String json = "{\"v\":\"\"}";
        Cell c = Cell.loadStreaming((String)json, (Pool)this.pool);
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeErrorCell() throws Exception {
        String json = "{\"e\":\"HTTP 403\"}";
        Cell c = Cell.loadStreaming((String)json, (Pool)this.pool);
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void getMessageFromErrorCell() throws Exception {
        String errorMessage = "Sample error message";
        EvalError err = new EvalError(errorMessage);
        Cell c = new Cell((Serializable)err, null);
        Assert.assertEquals((Object)c.getField("errorMessage", null), (Object)errorMessage);
        Assert.assertEquals((Object)c.getField("value", null), (Object)err);
    }

    @Test
    public void serializeDateCell() throws Exception {
        String json = "{\"v\":\"2018-03-04T08:09:10Z\",\"t\":\"date\"}";
        TestUtils.isSerializedTo(Cell.loadStreaming((String)json, (Pool)this.pool), json);
    }

    @Test
    public void serializeNumberCell() throws Exception {
        String json = "{\"v\": 1}";
        Cell c = Cell.loadStreaming((String)json, (Pool)this.pool);
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeBooleanCell() throws Exception {
        String json = "{\"v\": true}";
        Cell c = Cell.loadStreaming((String)json, (Pool)this.pool);
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeDatewithOffset() throws Exception {
        OffsetDateTime dateTimeValue = OffsetDateTime.parse("2017-05-12T05:45:00+01:00", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        Cell c = new Cell((Serializable)dateTimeValue, null);
        String json = "{\"v\":\"2017-05-12T04:45:00Z\",\"t\":\"date\"}";
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeLocalDate() throws Exception {
        LocalDateTime dateTimeValue = LocalDateTime.of(2017, 5, 12, 0, 0, 0);
        Cell c = new Cell((Serializable)dateTimeValue, null);
        String json = "{\"v\":\"2017-05-12T00:00:00Z\",\"t\":\"date\"}";
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeDoubleNan() throws Exception {
        double dn = Double.NaN;
        Cell c = new Cell((Serializable)Double.valueOf(dn), null);
        String json = "{\"v\":\"NaN\"}";
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeFloatNan() throws Exception {
        Float fn = Float.valueOf(Float.NaN);
        Cell c = new Cell((Serializable)fn, null);
        String json = "{\"v\":\"NaN\"}";
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeDoubleInfinity() throws Exception {
        double di = Double.POSITIVE_INFINITY;
        Cell c = new Cell((Serializable)Double.valueOf(di), null);
        String json = "{\"v\":\"Infinity\"}";
        TestUtils.isSerializedTo(c, json);
    }

    @Test
    public void serializeFloatInfinity() throws Exception {
        Float fi = Float.valueOf(Float.POSITIVE_INFINITY);
        Cell c = new Cell((Serializable)fi, null);
        String json = "{\"v\":\"Infinity\"}";
        TestUtils.isSerializedTo(c, json);
    }
}

