/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.model;

import com.google.refine.RefineTest;
import com.google.refine.model.ColumnModel;
import com.google.refine.model.Project;
import com.google.refine.util.TestUtils;
import java.io.Serializable;
import org.testng.annotations.Test;

public class ColumnModelTests
extends RefineTest {
    @Test
    public void serializeColumnModel() {
        Project project = this.createProject(new String[]{"a", "b"}, new Serializable[][]{{"e", "e"}});
        String json = "{\n       \"columnGroups\" : [ ],\n       \"columns\" : [ {\n         \"cellIndex\" : 0,\n         \"name\" : \"a\",\n         \"originalName\" : \"a\"\n       }, {\n         \"cellIndex\" : 1,\n         \"name\" : \"b\",\n         \"originalName\" : \"b\"\n       } ],\n       \"keyCellIndex\" : 0,\n       \"keyColumnName\" : \"a\"\n     }";
        TestUtils.isSerializedTo(project.columnModel, json);
    }

    @Test
    public void serializeColumnModelEmpty() {
        String json = "{\"columns\":[],\"columnGroups\":[]}";
        ColumnModel m = new ColumnModel();
        TestUtils.isSerializedTo(m, json);
    }
}

