/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.cell;

import com.google.refine.ProjectManager;
import com.google.refine.RefineTest;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.model.AbstractOperation;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.cell.BlankDownOperation;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class BlankDownTests
extends RefineTest {
    Project project = null;

    @BeforeSuite
    public void registerOperation() {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"blank-down", BlankDownOperation.class);
    }

    @BeforeMethod
    public void setUp() {
        this.project = this.createProject(new String[]{"key", "first", "second"}, new Serializable[][]{{"a", "b", "c"}, {null, "d", "c"}, {"e", "f", "c"}, {null, null, "c"}});
    }

    @AfterMethod
    public void tearDown() {
        ProjectManager.singleton.deleteProject(this.project.id);
    }

    @Test
    public void serializeBlankDownOperation() throws Exception {
        String json = "{\"op\":\"core/blank-down\",\"description\":\"Blank down cells in column my column\",\"engineConfig\":{\"mode\":\"record-based\",\"facets\":[]},\"columnName\":\"my column\"}";
        AbstractOperation op = (AbstractOperation)ParsingUtilities.mapper.readValue(json, BlankDownOperation.class);
        TestUtils.isSerializedTo(op, json);
    }

    @Test
    public void testBlankDownRecords() throws Exception {
        BlankDownOperation op = new BlankDownOperation(EngineConfig.reconstruct((String)"{\"mode\":\"record-based\",\"facets\":[]}"), "second");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value);
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(2));
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)2)).value);
        Assert.assertNull(((Row)this.project.rows.get((int)3)).cells.get(2));
    }

    @Test
    public void testBlankDownRows() throws Exception {
        BlankDownOperation op = new BlankDownOperation(EngineConfig.reconstruct((String)"{\"mode\":\"row-based\",\"facets\":[]}"), "second");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)2)).value);
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(2));
        Assert.assertNull(((Row)this.project.rows.get((int)2)).cells.get(2));
        Assert.assertNull(((Row)this.project.rows.get((int)3)).cells.get(2));
    }

    @Test
    public void testKeyColumnIndex() throws Exception {
        for (Object r : this.project.rows) {
            ((Row)r).cells.add(0, null);
        }
        ArrayList<Column> newColumns = new ArrayList<Column>();
        for (Column c : this.project.columnModel.columns) {
            newColumns.add(new Column(c.getCellIndex() + 1, c.getName()));
        }
        this.project.columnModel.columns.clear();
        this.project.columnModel.columns.addAll(newColumns);
        this.project.columnModel.update();
        BlankDownOperation op = new BlankDownOperation(EngineConfig.reconstruct((String)"{\"mode\":\"record-based\",\"facets\":[]}"), "second");
        Process process = op.createProcess(this.project, new Properties());
        process.performImmediate();
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)3)).value);
        Assert.assertNull(((Row)this.project.rows.get((int)1)).cells.get(3));
        Assert.assertEquals((Object)"c", (Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)3)).value);
        Assert.assertNull(((Row)this.project.rows.get((int)3)).cells.get(3));
    }
}

