/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine;

import com.google.refine.RefineServletStub;
import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class RefineServletTests
extends RefineTest {
    RefineServletStub SUT = null;
    private static final String TEST_COMMAND_NAME = "test-command";
    private static final String TEST_COMMAND_PATH = "/command/core/test-command/foobar";
    private static final String BAD_COMMAND_PATH = "/command/core/command-does-not-exist";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    Command command = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws ServletException {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.command = (Command)Mockito.mock(Command.class);
        this.SUT = new RefineServletStub();
        this.SUT.insertCommand(TEST_COMMAND_NAME, this.command);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT.removeCommand(TEST_COMMAND_NAME);
        this.SUT = null;
        this.request = null;
        this.response = null;
        this.command = null;
    }

    @Test
    public void doGetRegressionTest() {
        this.whenGetCommandNameThenReturn(TEST_COMMAND_PATH);
        this.whenGetMethodThenReturn(GET);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        try {
            ((Command)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).doGet(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void doGetReturnsError404WhenCommandNotFound() {
        this.whenGetCommandNameThenReturn(BAD_COMMAND_PATH);
        this.whenGetMethodThenReturn(GET);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        this.verifyError404Called();
    }

    @Test
    public void doPostRegressionTest() {
        this.whenGetCommandNameThenReturn(TEST_COMMAND_PATH);
        this.whenGetMethodThenReturn(POST);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        try {
            ((Command)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).doPost(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void doPostReturns404WhenCommandNotFound() {
        this.whenGetCommandNameThenReturn(BAD_COMMAND_PATH);
        this.whenGetMethodThenReturn(POST);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        this.verifyError404Called();
    }

    @Test
    public void doPutRegressionTest() {
        this.whenGetCommandNameThenReturn(TEST_COMMAND_PATH);
        this.whenGetMethodThenReturn(PUT);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        try {
            ((Command)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).doPut(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void doPutReturns404WhenCommandNotFound() {
        this.whenGetCommandNameThenReturn(BAD_COMMAND_PATH);
        this.whenGetMethodThenReturn(PUT);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        this.verifyError404Called();
    }

    @Test
    public void doDeleteRegressionTest() {
        this.whenGetCommandNameThenReturn(TEST_COMMAND_PATH);
        this.whenGetMethodThenReturn(DELETE);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        try {
            ((Command)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).doDelete(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void doDeleteReturns404WhenCommandNotFound() {
        this.whenGetCommandNameThenReturn(BAD_COMMAND_PATH);
        this.whenGetMethodThenReturn(DELETE);
        try {
            this.SUT.wrapService(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        this.verifyGetCommandNameCalled(2);
        this.verifyError404Called();
    }

    @Test
    public void getCommandNameHandlesBadCommandName() {
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)"/command/this-command-has-no-trailing-slash");
        Assert.assertEquals((String)"this-command-has-no-trailing-slash", (String)this.SUT.wrapGetCommandName(this.request));
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getPathInfo();
    }

    protected void whenGetCommandNameThenReturn(String commandName) {
        Mockito.when((Object)this.request.getPathInfo()).thenReturn((Object)commandName);
    }

    protected void whenGetMethodThenReturn(String method) {
        Mockito.when((Object)this.request.getMethod()).thenReturn((Object)method);
    }

    protected void verifyGetCommandNameCalled(int times) {
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)times))).getPathInfo();
    }

    protected void verifyError404Called() {
        try {
            ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).sendError(404);
        }
        catch (IOException e) {
            Assert.fail();
        }
    }
}

