/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.clustering.binning;

import com.google.refine.RefineTest;
import com.google.refine.clustering.binning.FingerprintKeyer;
import com.google.refine.clustering.binning.Keyer;
import com.google.refine.clustering.binning.NGramFingerprintKeyer;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class KeyerTests
extends RefineTest {
    private static Keyer keyer;
    private static final String[][] testStrings;
    private static final String[][] testNGramStrings;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        keyer = new FingerprintKeyer();
    }

    @Override
    @AfterMethod
    public void TearDown() {
        keyer = null;
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidParams() {
        keyer.key("test", (Object[])new String[]{"foo"});
    }

    @Test
    public void testFingerprintKeyer() {
        for (String[] ss : testStrings) {
            Assert.assertEquals((int)ss.length, (int)2, (String)"Invalid test");
            Assert.assertEquals((String)keyer.key(ss[0]), (String)ss[1], (String)("Fingerprint for string: " + ss[0] + " failed"));
        }
    }

    @Test
    public void testNGramKeyer() {
        keyer = new NGramFingerprintKeyer();
        for (String[] ss : testNGramStrings) {
            Assert.assertEquals((int)ss.length, (int)2, (String)"Invalid test");
            Assert.assertEquals((String)keyer.key(ss[0]), (String)ss[1], (String)("Fingerprint for string: " + ss[0] + " failed"));
        }
    }

    static {
        testStrings = new String[][]{{"the multi multi word test", "multi test the word"}, {" \u00e9cole \u00c9Cole ecoLe ", "ecole"}, {"a b c d", "a b c d"}, {" d c b a ", "a b c d"}, {"\tABC \t DEF ", "abc def"}, {"bbb\taaa", "aaa bbb"}, {"\u00e6\u00f8", "aeoe"}, {"\u00a9\u00df", "css"}, {"\u00d0\u00f0\u00de\u00fe\u01f7\u01bf", "ddththww"}, {"\ufb00\ufb01\ufb02\ufb03\ufb05\ufb06", "fffiflffistst"}, {"\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u0100\u0101\u0102\u0103\u0104\u0105", "aaaaaaaaaaaaaaaaaa"}, {"\u00c7\u00e7\u0106\u0107\u0108\u0109\u010a\u010b\u010c\u010d", "cccccccccc"}, {"\u00d0\u00f0\u010e\u010f\u0110\u0111", "dddddd"}, {"\u00c8\u00c9\u00ca\u00cb\u00e8\u00e9\u00ea\u00eb\u0112\u0113\u0114\u0115\u0116\u0117\u0118\u0119\u011a\u011b", "eeeeeeeeeeeeeeeeee"}, {"\u011c\u011d\u011e\u011f\u0120\u0121\u0122\u0123", "gggggggg"}, {"\u0124\u0125", "hh"}, {"\u0126\u0127", "hh"}, {"\u00cc\u00cd\u00ce\u00cf\u00ec\u00ed\u00ee\u00ef\u0128\u0129\u012a\u012b\u012c\u012d\u012e\u012f\u0130", "iiiiiiiiiiiiiiiii"}, {"\u0131", "i"}, {"\u0134\u0135", "jj"}, {"\u0136\u0137", "kk"}, {"\u0138", "k"}, {"\u0139\u013a\u013b\u013c\u013d\u013e\u0141\u0142", "llllllll"}, {"\u013f\u0140", "ll"}, {"\u00d1\u00f1\u0143\u0144\u0145\u0146\u0147\u0148", "nnnnnnnn"}, {"\u0149", "n"}, {"\u014a\u014b", "nn"}, {"\u00d2\u00d3\u00d4\u00d5\u00d6\u00f2\u00f3\u00f4\u00f5\u00f6\u014c\u014d\u014e\u014f\u0150\u0151", "oooooooooooooooo"}, {"\u00d8\u00f8", "oeoe"}, {"\u0154\u0155\u0156\u0157\u0158\u0159", "rrrrrr"}, {"\u015a\u015b\u015c\u015d\u015e\u015f\u0160\u0161\u017f", "sssssssss"}, {"\u0162\u0163\u0164\u0165\u0166\u0167", "tttttt"}, {"\u00d9\u00da\u00db\u00dc\u00f9\u00fa\u00fb\u00fc\u0168\u0169\u016a\u016b\u016c\u016d\u016e\u016f\u0170\u0171\u0172\u0173", "uuuuuuuuuuuuuuuuuuuu"}, {"\u0174\u0175", "ww"}, {"\u00dd\u00fd\u00ff\u0176\u0177\u0178", "yyyyyy"}, {"\u0179\u017a\u017b\u017c\u017d\u017e", "zzzzzz"}, {"a\t\nb\u000bc\fd\re\u0085f\u00a0g\u1680h\u2000i\u2001j\u2002k\u2003l\u2004m\u2005n\u2006o\u2007p\u2008q\u2009r\u200as\u2028t\u2029u\u202fv\u205fw\u3000z", "a b c d e f g h i j k l m n o p q r s t u v w z"}, {"\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff", "aaaaaaaeceeeeiiiidnooooooeuuuuythssaaaaaaaeceeeeiiiidnooooooeuuuuythy"}, {"\u0100\u0101\u0102\u0103\u0104\u0105\u0106\u0107\u0108\u0109\u010a\u010b\u010c\u010d\u010e\u010f\u0110\u0111\u0112\u0113\u0114\u0115\u0116\u0117\u0118\u0119\u011a\u011b\u011c\u011d\u011e\u011f\u0120\u0121\u0122\u0123\u0124\u0125\u0126\u0127\u0128\u0129\u012a\u012b\u012c\u012d\u012e\u012f\u0130\u0131\u0132\u0133\u0134\u0135\u0136\u0137\u0138\u0139\u013a\u013b\u013c\u013d\u013e\u013f\u0140\u0141\u0142\u0143\u0144\u0145\u0146\u0147\u0148\u0149\u014a\u014b\u014c\u014d\u014e\u014f\u0150\u0151\u0152\u0153\u0154\u0155\u0156\u0157\u0158\u0159\u015a\u015b\u015c\u015d\u015e\u015f\u0160\u0161\u0162\u0163\u0164\u0165\u0166\u0167\u0168\u0169\u016a\u016b\u016c\u016d\u016e\u016f\u0170\u0171\u0172\u0173\u0174\u0175\u0176\u0177\u0178\u0179\u017a\u017b\u017c\u017d\u017e\u017f", "aaaaaaccccccccddddeeeeeeeeeegggggggghhhhiiiiiiiiiiijijjjkkkllllllllllnnnnnnnnnoooooooeoerrrrrrssssssssttttttuuuuuuuuuuuuwwyyyzzzzzzs"}, {"\u1e00\u1e01\u1e02\u1e03\u1e04\u1e05\u1e06\u1e07\u1e08\u1e09\u1e0a\u1e0b\u1e0c\u1e0d\u1e0e\u1e0f\u1e10\u1e11\u1e12\u1e13\u1e14\u1e15\u1e16\u1e17\u1e18\u1e19\u1e1a\u1e1b\u1e1c\u1e1d\u1e1e\u1e1f\u1e20\u1e21\u1e22\u1e23\u1e24\u1e25\u1e26\u1e27\u1e28\u1e29\u1e2a\u1e2b\u1e2c\u1e2d\u1e2e\u1e2f\u1e30\u1e31\u1e32\u1e33\u1e34\u1e35\u1e36\u1e37\u1e38\u1e39\u1e3a\u1e3b\u1e3c\u1e3d\u1e3e\u1e3f\u1e40\u1e41\u1e42\u1e43\u1e44\u1e45\u1e46\u1e47\u1e48\u1e49\u1e4a\u1e4b\u1e4c\u1e4d\u1e4e\u1e4f\u1e50\u1e51\u1e52\u1e53\u1e54\u1e55\u1e56\u1e57", "aabbbbbbccddddddddddeeeeeeeeeeffgghhhhhhhhhhiiiikkkkkkllllllllmmmmmmnnnnnnnnoooooooopppp"}, {"\u1e58\u1e59\u1e5a\u1e5b\u1e5c\u1e5d\u1e5e\u1e5f\u1e60\u1e61\u1e62\u1e63\u1e64\u1e65\u1e66\u1e67\u1e68\u1e69\u1e6a\u1e6b\u1e6c\u1e6d\u1e6e\u1e6f\u1e70\u1e71\u1e72\u1e73\u1e74\u1e75\u1e76\u1e77\u1e78\u1e79\u1e7a\u1e7b\u1e7c\u1e7d\u1e7e\u1e7f\u1e80\u1e81\u1e82\u1e83\u1e84\u1e85\u1e86\u1e87\u1e88\u1e89\u1e8a\u1e8b\u1e8c\u1e8d\u1e8e\u1e8f\u1e90\u1e91\u1e92\u1e93\u1e94\u1e95", "rrrrrrrrssssssssssttttttttuuuuuuuuuuvvvvwwwwwwwwwwxxxxyyzzzzzz"}, {"\u1e96\u1e97\u1e98\u1e99\u1e9a\u1e9b\u1e9c\u1e9d\u1e9e\u1ea0\u1ea1\u1ea2\u1ea3\u1ea4\u1ea5\u1ea6\u1ea7\u1ea8\u1ea9\u1eaa\u1eab\u1eac\u1ead\u1eae\u1eaf\u1eb0\u1eb1\u1eb2\u1eb3\u1eb4\u1eb5\u1eb6\u1eb7\u1eb8\u1eb9\u1eba\u1ebb\u1ebc\u1ebd\u1ebe\u1ebf\u1ec0\u1ec1\u1ec2\u1ec3\u1ec4\u1ec5\u1ec6\u1ec7", "htwyasssssaaaaaaaaaaaaaaaaaaaaaaaaeeeeeeeeeeeeeeee"}, {"", ""}, {"", ""}, {"", ""}};
        testNGramStrings = new String[][]{{"abcdefg", "abbccddeeffg"}, {"gfedcba", "bacbdcedfegf"}, {"a b c d e f g", "abbccddeeffg"}, {" a,b.c d\te!f?g ", "abbccddeeffg"}, {"\u00e9c\u00c9Cec", "ceec"}, {"a\t\nb\u000bc\fd\re\u0085f\u00a0g\u1680h\u2000i\u2001j\u2002k\u2003l\u2004m\u2005n\u2006o\u2007p\u2008q\u2009r\u200as\u2028t\u2029u\u202fv\u205fw\u3000z", "abbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwz"}, {"", ""}, {"", ""}};
    }
}

