/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

public class CommandTestBase
extends RefineTest {
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected Command command = null;
    protected StringWriter writer = null;

    @BeforeMethod
    public void setUpRequestResponse() {
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.writer = new StringWriter();
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(this.writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void assertCSRFCheckFailed() {
        TestUtils.assertEqualsAsJson(this.writer.toString(), "{\"code\":\"error\",\"message\":\"Missing or invalid csrf_token parameter\"}");
    }

    protected void assertErrorNotCSRF() throws JsonProcessingException {
        String response = this.writer.toString();
        JsonNode node = (JsonNode)ParsingUtilities.mapper.readValue(response, JsonNode.class);
        Assert.assertEquals((String)node.get("code").toString(), (String)"\"error\"");
        Assert.assertFalse((boolean)response.contains("Missing or invalid csrf_token parameter"));
    }
}

