/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.expr;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.commands.CommandTestBase;
import com.google.refine.io.FileProjectManager;
import com.google.refine.model.Project;
import com.google.refine.model.ProjectStub;
import com.google.refine.preference.PreferenceStore;
import com.google.refine.preference.TopList;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.testng.Assert;

public class ExpressionCommandTestBase
extends CommandTestBase {
    protected static long PROJECT_ID = 1234L;

    public void initWorkspace(String globalExpressionsJson, String starredExpressionsJson, String localExpressionsJson) {
        String starred = starredExpressionsJson == null ? "{\"class\":\"com.google.refine.preference.TopList\",\"top\":2147483647,\"list\":[]}" : starredExpressionsJson;
        String globalExpressions = globalExpressionsJson == null ? "{\"class\":\"com.google.refine.preference.TopList\",\"top\":100,\"list\":[]}" : globalExpressionsJson;
        String localExpressions = localExpressionsJson == null ? "{\"class\":\"com.google.refine.preference.TopList\",\"top\":100,\"list\":[]}" : localExpressionsJson;
        this.initWorkspaceInternal(starred, globalExpressions, localExpressions);
    }

    private void initWorkspaceInternal(String starred, String global, String local) {
        String jsonData = "{\"projectIDs\":[]\n,\"preferences\":{\"entries\":{\"scripting.starred-expressions\":" + starred + ",\"scripting.expressions\":" + global + "}}}";
        this.initWorkspace(jsonData);
        ProjectStub project = new ProjectStub(PROJECT_ID);
        ProjectMetadata pm = new ProjectMetadata();
        PreferenceStore prefs = pm.getPreferenceStore();
        try {
            prefs.put("scripting.expressions", ParsingUtilities.mapper.readValue(local, TopList.class));
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)"Can't parse expression history JSON");
        }
        ProjectManager.singleton.registerProject((Project)project, pm);
    }

    public void initWorkspace(String jsonData) {
        try {
            File workspaceDir = TestUtils.createTempDirectory("openrefine-test-workspace-dir");
            File jsonPath = new File(workspaceDir, "workspace.json");
            FileUtils.writeStringToFile((File)jsonPath, (String)jsonData);
            FileProjectManager.initialize((File)workspaceDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void assertResponseJsonIs(String expectedJson) {
        String actualJson = this.writer.toString();
        if (!TestUtils.equalAsJson(expectedJson, actualJson)) {
            try {
                TestUtils.jsonDiff(expectedJson, actualJson);
            }
            catch (JsonParseException | JsonMappingException e) {
                e.printStackTrace();
            }
        }
        TestUtils.assertEqualsAsJson(actualJson, expectedJson);
    }
}

