/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.expr;

import com.google.refine.commands.Command;
import com.google.refine.commands.CommandTestBase;
import com.google.refine.commands.expr.PreviewExpressionCommand;
import com.google.refine.model.Project;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PreviewExpressionCommandTests
extends CommandTestBase {
    protected Project project = null;

    @BeforeMethod
    public void setUpCommandAndProject() {
        this.command = new PreviewExpressionCommand();
        this.project = this.createProject(new String[]{"a", "b"}, new Serializable[][]{{"c", "d"}, {"e", "f"}, {"g", "h"}});
    }

    @Test
    public void testCSRFProtection() throws ServletException, IOException {
        this.command.doPost(this.request, this.response);
        this.assertCSRFCheckFailed();
    }

    @Test
    public void testJsonResponse() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("cellIndex")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("expression")).thenReturn((Object)"grel:value + \"_u\"");
        Mockito.when((Object)this.request.getParameter("rowIndices")).thenReturn((Object)"[0,2]");
        String json = "{\n       \"code\" : \"ok\",\n       \"results\" : [ \"d_u\", \"h_u\" ]\n     }";
        this.command.doPost(this.request, this.response);
        TestUtils.assertEqualsAsJson(this.writer.toString(), json);
    }

    @Test
    public void testParseError() throws ServletException, IOException {
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)Long.toString(this.project.id));
        Mockito.when((Object)this.request.getParameter("cellIndex")).thenReturn((Object)"1");
        Mockito.when((Object)this.request.getParameter("expression")).thenReturn((Object)"grel:value +");
        Mockito.when((Object)this.request.getParameter("rowIndices")).thenReturn((Object)"[0,2]");
        String json = "{\n       \"code\" : \"error\",\n       \"message\" : \"Parsing error at offset 7: Expecting something more at end of expression\",\n       \"type\" : \"parser\"\n     }";
        this.command.doPost(this.request, this.response);
        TestUtils.assertEqualsAsJson(this.writer.toString(), json);
    }
}

