/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.commands.util;

import com.google.refine.ProjectManager;
import com.google.refine.RefineTest;
import com.google.refine.commands.Command;
import com.google.refine.commands.history.CancelProcessesCommand;
import com.google.refine.model.Project;
import com.google.refine.process.ProcessManager;
import com.google.refine.util.TestUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CancelProcessesCommandTests
extends RefineTest {
    CancelProcessesCommand SUT = null;
    long PROJECT_ID_LONG = 1234L;
    String PROJECT_ID = "1234";
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    ProjectManager projMan = null;
    Project proj = null;
    ProcessManager processMan = null;
    StringWriter sw = null;
    PrintWriter pw = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        ProjectManager.singleton = this.projMan = (ProjectManager)Mockito.mock(ProjectManager.class);
        this.proj = (Project)Mockito.mock(Project.class);
        this.processMan = (ProcessManager)Mockito.mock(ProcessManager.class);
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.SUT = new CancelProcessesCommand();
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.projMan = null;
        ProjectManager.singleton = null;
        this.proj = null;
        this.sw = null;
        this.request = null;
        this.response = null;
    }

    @Test
    public void doPostFailsThrowsWithNullParameters() {
        try {
            this.SUT.doPost(null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.SUT.doPost(null, this.response);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            this.SUT.doPost(this.request, null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void doPostRegressionTest() {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)this.PROJECT_ID);
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.projMan.getProject(ArgumentMatchers.anyLong())).thenReturn((Object)this.proj);
        Mockito.when((Object)this.proj.getProcessManager()).thenReturn((Object)this.processMan);
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)this.pw);
        }
        catch (IOException e1) {
            Assert.fail();
        }
        try {
            this.SUT.doPost(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("project");
        ((ProjectManager)Mockito.verify((Object)this.projMan, (VerificationMode)Mockito.times((int)1))).getProject(this.PROJECT_ID_LONG);
        ((ProcessManager)Mockito.verify((Object)this.processMan, (VerificationMode)Mockito.times((int)1))).cancelAll();
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setCharacterEncoding("UTF-8");
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).setHeader("Content-Type", "application/json");
        ((Project)Mockito.verify((Object)this.proj, (VerificationMode)Mockito.times((int)1))).getProcessManager();
        try {
            ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)1))).getWriter();
        }
        catch (IOException e) {
            Assert.fail();
        }
        TestUtils.assertEqualsAsJson(this.sw.toString(), "{ \"code\" : \"ok\" }");
    }

    @Test
    public void doPostThrowsIfCommand_getProjectReturnsNull() {
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)this.PROJECT_ID);
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.projMan.getProject(ArgumentMatchers.anyLong())).thenReturn(null);
        try {
            Mockito.when((Object)this.response.getWriter()).thenReturn((Object)this.pw);
        }
        catch (IOException e1) {
            Assert.fail();
        }
        try {
            this.SUT.doPost(this.request, this.response);
        }
        catch (ServletException e1) {
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("project");
        ((ProjectManager)Mockito.verify((Object)this.projMan, (VerificationMode)Mockito.times((int)1))).getProject(this.PROJECT_ID_LONG);
    }

    @Test
    public void doPostCatchesExceptionFromWriter() {
        String ERROR_MESSAGE = "hello world";
        Mockito.when((Object)this.request.getParameter("project")).thenReturn((Object)this.PROJECT_ID);
        Mockito.when((Object)this.request.getParameter("csrf_token")).thenReturn((Object)Command.csrfFactory.getFreshToken());
        Mockito.when((Object)this.projMan.getProject(ArgumentMatchers.anyLong())).thenReturn((Object)this.proj);
        Mockito.when((Object)this.proj.getProcessManager()).thenReturn((Object)this.processMan);
        try {
            Mockito.when((Object)this.response.getWriter()).thenThrow(new Throwable[]{new IllegalStateException(ERROR_MESSAGE)}).thenReturn((Object)this.pw);
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            this.SUT.doPost(this.request, this.response);
        }
        catch (ServletException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        ((HttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getParameter("project");
        ((ProjectManager)Mockito.verify((Object)this.projMan, (VerificationMode)Mockito.times((int)1))).getProject(this.PROJECT_ID_LONG);
        ((ProcessManager)Mockito.verify((Object)this.processMan, (VerificationMode)Mockito.times((int)1))).cancelAll();
        ((HttpServletResponse)Mockito.verify((Object)this.response, (VerificationMode)Mockito.times((int)2))).setCharacterEncoding("UTF-8");
    }
}

