/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.exporters.TemplatingExporter;
import com.google.refine.exporters.WriterExporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TemplatingExporterTests
extends RefineTest {
    private static final String TEST_PROJECT_NAME = "templating exporter test project";
    String rowPrefix = "boilerplate";
    String cellSeparator = "spacer";
    String prefix = "test prefix>";
    String suffix = "<test suffix";
    String rowSeparator = "\n";
    StringWriter writer;
    ProjectMetadata projectMetadata;
    Project project;
    Engine engine;
    Properties options;
    WriterExporter SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new TemplatingExporter();
        this.writer = new StringWriter();
        ProjectManager.singleton = new ProjectManagerStub();
        this.projectMetadata = new ProjectMetadata();
        this.project = new Project();
        this.projectMetadata.setName(TEST_PROJECT_NAME);
        ProjectManager.singleton.registerProject(this.project, this.projectMetadata);
        this.engine = new Engine(this.project);
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.writer = null;
        ProjectManager.singleton.deleteProject(this.project.id);
        this.project = null;
        this.engine = null;
        this.options = null;
    }

    @Test
    public void exportEmptyTemplate() {
        Mockito.when((Object)this.options.getProperty("template")).thenReturn((Object)"a template that should never get used");
        Mockito.when((Object)this.options.getProperty("prefix")).thenReturn((Object)this.prefix);
        Mockito.when((Object)this.options.getProperty("suffix")).thenReturn((Object)this.suffix);
        Mockito.when((Object)this.options.getProperty("separator")).thenReturn((Object)this.rowSeparator);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)(this.prefix + this.suffix));
    }

    @Test
    public void exportSimpleTemplate() {
        this.CreateGrid(2, 2);
        String template = this.rowPrefix + "${column0}" + this.cellSeparator + "${column1}";
        Mockito.when((Object)this.options.getProperty("template")).thenReturn((Object)template);
        Mockito.when((Object)this.options.getProperty("prefix")).thenReturn((Object)this.prefix);
        Mockito.when((Object)this.options.getProperty("suffix")).thenReturn((Object)this.suffix);
        Mockito.when((Object)this.options.getProperty("separator")).thenReturn((Object)this.rowSeparator);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)(this.prefix + this.rowPrefix + "row0cell0" + this.cellSeparator + "row0cell1" + this.rowSeparator + this.rowPrefix + "row1cell0" + this.cellSeparator + "row1cell1" + this.suffix));
    }

    @Test
    public void exportTemplateWithEmptyCells() {
        Mockito.when((Object)this.options.getProperty("template")).thenReturn((Object)(this.rowPrefix + "${column0}" + this.cellSeparator + "${column1}" + this.cellSeparator + "${column2}"));
        Mockito.when((Object)this.options.getProperty("template")).thenReturn((Object)(this.rowPrefix + "${column0}" + this.cellSeparator + "${column1}" + this.cellSeparator + "${column2}"));
        Mockito.when((Object)this.options.getProperty("prefix")).thenReturn((Object)this.prefix);
        Mockito.when((Object)this.options.getProperty("suffix")).thenReturn((Object)this.suffix);
        Mockito.when((Object)this.options.getProperty("separator")).thenReturn((Object)this.rowSeparator);
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, null);
        ((Row)this.project.rows.get((int)2)).cells.set(0, null);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)(this.prefix + this.rowPrefix + "row0cell0" + this.cellSeparator + "row0cell1" + this.cellSeparator + "row0cell2" + this.rowSeparator + this.rowPrefix + "row1cell0" + this.cellSeparator + "null" + this.cellSeparator + "row1cell2" + this.rowSeparator + this.rowPrefix + "null" + this.cellSeparator + "row2cell1" + this.cellSeparator + "row2cell2" + this.suffix));
    }

    @Test
    public void exportTemplateWithLimit() {
        Mockito.when((Object)this.options.getProperty("limit")).thenReturn((Object)"2");
        Mockito.when((Object)this.options.getProperty("template")).thenReturn((Object)(this.rowPrefix + "${column0}" + this.cellSeparator + "${column1}" + this.cellSeparator + "${column2}"));
        Mockito.when((Object)this.options.getProperty("prefix")).thenReturn((Object)this.prefix);
        Mockito.when((Object)this.options.getProperty("suffix")).thenReturn((Object)this.suffix);
        Mockito.when((Object)this.options.getProperty("separator")).thenReturn((Object)this.rowSeparator);
        this.CreateGrid(3, 3);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)(this.prefix + this.rowPrefix + "row0cell0" + this.cellSeparator + "row0cell1" + this.cellSeparator + "row0cell2" + this.rowSeparator + this.rowPrefix + "row1cell0" + this.cellSeparator + "row1cell1" + this.cellSeparator + "row1cell2" + this.suffix));
    }

    @Test
    public void exportTemplateInRecordMode() {
        this.CreateColumns(2);
        for (int i = 0; i < 2; ++i) {
            Row row = new Row(2);
            for (int j = 0; j < 2; ++j) {
                if (i == 1 && j == 0) {
                    row.cells.add(new Cell(null, null));
                    continue;
                }
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
        String template = this.rowPrefix + "${column0}" + this.cellSeparator + "${column1}";
        Mockito.when((Object)this.options.getProperty("template")).thenReturn((Object)template);
        Mockito.when((Object)this.options.getProperty("prefix")).thenReturn((Object)this.prefix);
        Mockito.when((Object)this.options.getProperty("suffix")).thenReturn((Object)this.suffix);
        Mockito.when((Object)this.options.getProperty("separator")).thenReturn((Object)this.rowSeparator);
        Engine engine = new Engine(this.project);
        engine.setMode(Engine.Mode.RecordBased);
        this.project.update();
        try {
            this.SUT.export(this.project, this.options, engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)(this.prefix + this.rowPrefix + "row0cell0" + this.cellSeparator + "row0cell1" + this.rowSeparator + this.rowPrefix + "null" + this.cellSeparator + "row1cell1" + this.suffix));
    }

    @Test
    public void exportTemplateWithProperEscaping() {
        this.CreateGrid(2, 2);
        String template = this.rowPrefix + "{{\"\\}\\}\"}}" + this.cellSeparator + "{{\"\\}\\}\"}}";
        Mockito.when((Object)this.options.getProperty("template")).thenReturn((Object)template);
        Mockito.when((Object)this.options.getProperty("prefix")).thenReturn((Object)this.prefix);
        Mockito.when((Object)this.options.getProperty("suffix")).thenReturn((Object)this.suffix);
        Mockito.when((Object)this.options.getProperty("separator")).thenReturn((Object)this.rowSeparator);
        try {
            this.SUT.export(this.project, this.options, this.engine, (Writer)this.writer);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.writer.toString(), (String)(this.prefix + this.rowPrefix + "}}" + this.cellSeparator + "}}" + this.rowSeparator + this.rowPrefix + "}}" + this.cellSeparator + "}}" + this.suffix));
    }

    protected void CreateColumns(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void CreateGrid(int noOfRows, int noOfColumns) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }
}

