/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.exporters;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectManagerStub;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.exporters.StreamExporter;
import com.google.refine.exporters.XlsExporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Properties;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.SpreadsheetVersion;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class XlsExporterTests
extends RefineTest {
    private static final String TEST_PROJECT_NAME = "xls exporter test project";
    ByteArrayOutputStream stream;
    ProjectMetadata projectMetadata;
    Project project;
    Engine engine;
    Properties options;
    StreamExporter SUT;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.SUT = new XlsExporter(false);
        this.stream = new ByteArrayOutputStream();
        ProjectManager.singleton = new ProjectManagerStub();
        this.projectMetadata = new ProjectMetadata();
        this.project = new Project();
        this.projectMetadata.setName(TEST_PROJECT_NAME);
        ProjectManager.singleton.registerProject(this.project, this.projectMetadata);
        this.engine = new Engine(this.project);
        this.options = (Properties)Mockito.mock(Properties.class);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.SUT = null;
        this.stream = null;
        ProjectManager.singleton.deleteProject(this.project.id);
        this.project = null;
        this.engine = null;
        this.options = null;
    }

    @Test
    public void getContentType() {
        Assert.assertEquals((String)this.SUT.getContentType(), (String)"application/vnd.ms-excel");
    }

    @Test
    public void getSpreadsheetVersion() {
        XlsExporter exporter = (XlsExporter)this.SUT;
        Assert.assertEquals((Object)exporter.getSpreadsheetVersion(), (Object)SpreadsheetVersion.EXCEL97);
    }

    @Test
    public void exportSimpleXls() throws IOException {
        this.CreateGrid(2, 2);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((int)this.stream.size(), (int)4096);
        try (HSSFWorkbook wb = new HSSFWorkbook((InputStream)new ByteArrayInputStream(this.stream.toByteArray()));){
            HSSFSheet ws = wb.getSheetAt(0);
            org.apache.poi.ss.usermodel.Row row1 = ws.getRow(1);
            org.apache.poi.ss.usermodel.Cell cell0 = row1.getCell(0);
            Assert.assertEquals((String)cell0.toString(), (String)"row0cell0");
        }
    }

    @Test
    public void test256Columns() throws IOException {
        this.CreateGrid(2, 256);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        try (HSSFWorkbook wb = new HSSFWorkbook((InputStream)new ByteArrayInputStream(this.stream.toByteArray()));){
            HSSFSheet ws = wb.getSheetAt(0);
            org.apache.poi.ss.usermodel.Row row1 = ws.getRow(1);
            org.apache.poi.ss.usermodel.Cell cell0 = row1.getCell(255);
            Assert.assertEquals((String)cell0.toString(), (String)"row0cell255");
        }
    }

    @Test
    public void test257Columns() throws IOException {
        this.CreateGrid(2, 257);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        try (HSSFWorkbook wb = new HSSFWorkbook((InputStream)new ByteArrayInputStream(this.stream.toByteArray()));){
            HSSFSheet ws = wb.getSheetAt(0);
            org.apache.poi.ss.usermodel.Row row1 = ws.getRow(1);
            org.apache.poi.ss.usermodel.Cell cell0 = row1.getCell(255);
            Assert.assertEquals((String)cell0.toString(), (String)"ERROR: TOO MANY COLUMNS");
        }
    }

    @Test
    public void exportDateType() throws IOException {
        OffsetDateTime odt = OffsetDateTime.parse("2019-04-09T12:00+00:00");
        this.createDateGrid(2, 2, odt);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((int)this.stream.size(), (int)4096);
        try (HSSFWorkbook wb = new HSSFWorkbook((InputStream)new ByteArrayInputStream(this.stream.toByteArray()));){
            HSSFSheet ws = wb.getSheetAt(0);
            org.apache.poi.ss.usermodel.Row row1 = ws.getRow(1);
            org.apache.poi.ss.usermodel.Cell cell0 = row1.getCell(0);
            Assert.assertTrue((boolean)cell0.toString().contains("2019"));
        }
    }

    public void exportSimpleXlsNoHeader() {
        this.CreateGrid(2, 2);
        Mockito.when((Object)this.options.getProperty("printColumnHeader")).thenReturn((Object)"false");
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.stream.toString(), (String)"row0cell0,row0cell1\nrow1cell0,row1cell1\n");
        ((Properties)Mockito.verify((Object)this.options, (VerificationMode)Mockito.times((int)2))).getProperty("printColumnHeader");
    }

    public void exportXlsWithEmptyCells() {
        this.CreateGrid(3, 3);
        ((Row)this.project.rows.get((int)1)).cells.set(1, null);
        ((Row)this.project.rows.get((int)2)).cells.set(0, null);
        try {
            this.SUT.export(this.project, this.options, this.engine, (OutputStream)this.stream);
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertEquals((String)this.stream.toString(), (String)"column0,column1,column2\nrow0cell0,row0cell1,row0cell2\nrow1cell0,,row1cell2\n,row2cell1,row2cell2\n");
    }

    protected void CreateColumns(int noOfColumns) {
        for (int i = 0; i < noOfColumns; ++i) {
            try {
                this.project.columnModel.addColumn(i, new Column(i, "column" + i), true);
                continue;
            }
            catch (ModelException e1) {
                Assert.fail((String)"Could not create column");
            }
        }
    }

    protected void CreateGrid(int noOfRows, int noOfColumns) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)((Object)("row" + i + "cell" + j)), null));
            }
            this.project.rows.add(row);
        }
    }

    private void createDateGrid(int noOfRows, int noOfColumns, OffsetDateTime now) {
        this.CreateColumns(noOfColumns);
        for (int i = 0; i < noOfRows; ++i) {
            Row row = new Row(noOfColumns);
            for (int j = 0; j < noOfColumns; ++j) {
                row.cells.add(new Cell((Serializable)now, null));
            }
            this.project.rows.add(row);
        }
    }
}

