/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.HasFieldsListImpl;
import com.google.refine.expr.WrappedCell;
import com.google.refine.expr.WrappedRow;
import com.google.refine.model.Cell;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class CrossTests
extends RefineTest {
    private static final String ERROR_MSG = "cross expects a cell or value, a project name to look up (optional), and a column name in that project (optional)";
    private static final OffsetDateTime dateTimeValue = OffsetDateTime.parse("2017-05-12T05:45:00+00:00", DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    private HasFieldsListImpl emptyList;
    Project projectGift;
    Project projectAddress;
    Project projectDuplicate1;
    Project projectDuplicate2;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        bindings = new Properties();
        this.emptyList = new HasFieldsListImpl();
        this.projectAddress = this.createProject("My Address Book", new String[]{"friend", "address"}, new Serializable[][]{{"john", "120 Main St."}, {"mary", "50 Broadway Ave."}, {"john", "999 XXXXXX St."}, {"anne", "17 Morning Crescent"}, {dateTimeValue, "dateTime"}, {Integer.valueOf(1600), "integer"}, {Long.valueOf(123456789123456789L), "long"}, {Boolean.valueOf(true), "boolean"}, {Double.valueOf(3.14), "double"}});
        this.projectGift = this.createProject("Christmas Gifts", new String[]{"gift", "recipient"}, new Serializable[][]{{"lamp", "mary"}, {"clock", "john"}, {"dateTime", dateTimeValue}, {"integer", Integer.valueOf(1600)}, {"123456789123456789", Long.valueOf(123456789123456789L)}, {"boolean", Boolean.valueOf(true)}});
        this.projectDuplicate1 = this.createProject("Duplicate", new String[]{"Col1", "Col2"}, new Serializable[0][]);
        this.projectDuplicate2 = this.createProject("Duplicate", new String[]{"Col1", "Col2"}, new Serializable[0][]);
        bindings.put("project", this.projectGift);
        bindings.put("columnName", "recipient");
    }

    @Test
    public void crossFunctionMissingProject() throws Exception {
        String nonExistentProject = "NOPROJECT";
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"Anne", nonExistentProject, "friend"})).message, (String)("Unable to find project with name: " + nonExistentProject));
    }

    @Test
    public void crossFunctionMultipleProjects() throws Exception {
        String duplicateProjectName = "Duplicate";
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"Anne", duplicateProjectName, "friend"})).message, (String)("Multiple (2) projects found with name: " + duplicateProjectName));
    }

    @Test
    public void crossFunctionMissingColumn() throws Exception {
        String nonExistentColumn = "NoColumn";
        String projectName = "My Address Book";
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"mary", projectName, nonExistentColumn})).message, (String)("Unable to find column " + nonExistentColumn + " in project " + projectName));
    }

    @Test
    public void crossFunctionSameColumnTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)0)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"50 Broadway Ave.");
    }

    @Test
    public void crossFunctionDifferentColumnTest() throws Exception {
        Project project = (Project)bindings.get("project");
        bindings.put("columnName", "gift");
        Cell c = (Cell)((Row)project.rows.get((int)0)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"50 Broadway Ave.");
    }

    @Test
    public void crossFunctionOneArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0)})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"mary");
    }

    @Test
    public void crossFunctionOneArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0), ""})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"mary");
    }

    @Test
    public void crossFunctionOneArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)1), "", ""})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"john");
    }

    @Test
    public void crossFunctionTwoArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"lamp", "", "gift"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"mary");
    }

    @Test
    public void crossFunctionTwoArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0), "My Address Book"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"120 Main St.");
    }

    @Test
    public void crossFunctionTwoArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)0), "My Address Book", ""})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"120 Main St.");
    }

    @Test
    public void crossFunctionOneToOneTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"mary", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"50 Broadway Ave.");
    }

    @Test
    public void crossFunctionOneToManyTest() throws Exception {
        List rows = (List)CrossTests.invoke("cross", "john", "My Address Book", "friend");
        Assert.assertEquals((int)rows.size(), (int)2);
        Row row = ((WrappedRow)rows.get((int)1)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"999 XXXXXX St.");
    }

    @Test
    public void crossFunctionRecordFieldLookup() throws Exception {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"'john'.cross('My Address Book', 'friend').cells[0]['friend'].value", "john"}, {"'john'.cross('My Address Book', 'friend').index.toString()", "[0, 2]"}, {"'john'.cross('My Address Book', 'friend').columnNames[0].toString()", "[friend, address]"}, {"'john'.cross('My Address Book', 'friend').flagged.toString()", "[false, false]"}, {"'john'.cross('My Address Book', 'friend').starred.toString()", "[false, false]"}, {"'john'.cross('My Address Book', 'friend').foo.toString()", "[null, null]"}, {"'john'.cross('My Address Book', 'friend').record.cells['friend'].value.toString()", "[[john], [john]]"}, {"'john'.cross('My Address Book', 'friend').record.index.toString()", "[0, 2]"}, {"'john'.cross('My Address Book', 'friend').record.fromRowIndex.toString()", "[0, 2]"}, {"'john'.cross('My Address Book', 'friend').record.toRowIndex.toString()", "[1, 3]"}, {"'john'.cross('My Address Book', 'friend').record.rowCount.toString()", "[1, 1]"}, {"'john'.cross('My Address Book', 'friend').record.foo.toString()", "[null, null]"}}) {
            this.parseEval(bindings, test);
        }
    }

    @Test
    public void crossFunctionCaseSensitiveTest() throws Exception {
        Assert.assertEquals((Object)CrossTests.invoke("cross", "Anne", "My Address Book", "friend"), (Object)this.emptyList);
    }

    @Test
    public void crossFunctionDateTimeTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)2)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"dateTime");
    }

    @Test
    public void crossFunctionIntegerTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)3)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionBooleanTest() throws Exception {
        Project project = (Project)bindings.get("project");
        Cell c = (Cell)((Row)project.rows.get((int)5)).cells.get(1);
        WrappedCell lookup = new WrappedCell(project, "recipient", c);
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{lookup, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"boolean");
    }

    @Test
    public void crossFunctionIntegerArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Integer.valueOf((int)1600), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionIntegerArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Long.valueOf((long)1600L), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionIntegerArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"1600", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"integer");
    }

    @Test
    public void crossFunctionIntegerArgumentTest3() throws Exception {
        Assert.assertEquals((Object)CrossTests.invoke("cross", "1600.0", "My Address Book", "friend"), (Object)this.emptyList);
    }

    @Test
    public void crossFunctionLongArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Long.valueOf((long)123456789123456789L), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"long");
    }

    @Test
    public void crossFunctionLongArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"123456789123456789", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"long");
    }

    @Test
    public void crossFunctionDoubleArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Double.valueOf((double)3.14), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"double");
    }

    @Test
    public void crossFunctionDoubleArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Float.valueOf((float)3.14f), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"double");
    }

    @Test
    public void crossFunctionDoubleArgumentTest2() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"3.14", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"double");
    }

    @Test
    public void crossFunctionDateTimeArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{CrossTests.dateTimeValue, "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"dateTime");
    }

    @Test
    public void crossFunctionDateTimeArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{CrossTests.dateTimeValue.toString(), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"dateTime");
    }

    @Test
    public void crossFunctionBooleanArgumentTest() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{Boolean.valueOf((boolean)true), "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"boolean");
    }

    @Test
    public void crossFunctionBooleanArgumentTest1() throws Exception {
        Row row = ((WrappedRow)((HasFieldsListImpl)CrossTests.invoke((String)"cross", (Object[])new Object[]{"true", "My Address Book", "friend"})).get((int)0)).row;
        String address = row.getCell((int)1).value.toString();
        Assert.assertEquals((String)address, (String)"boolean");
    }

    @Test
    public void crossFunctionMatchNotFoundTest() throws Exception {
        Assert.assertEquals((Object)CrossTests.invoke("cross", "NON-EXIST", "My Address Book", "friend"), (Object)this.emptyList);
    }

    @Test
    public void crossFunctionNonLiteralValue() throws Exception {
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{null, "My Address Book", "friend"})).message, (String)ERROR_MSG);
    }

    @Test
    public void crossFunctionNullParams() throws Exception {
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"dummy", null, null})).message, (String)ERROR_MSG);
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"dummy", null})).message, (String)ERROR_MSG);
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"dummy", null, "test"})).message, (String)ERROR_MSG);
        Assert.assertEquals((String)((EvalError)CrossTests.invoke((String)"cross", (Object[])new Object[]{"dummy", Double.valueOf((double)1.0), Integer.valueOf((int)1)})).message, (String)ERROR_MSG);
    }
}

