/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.ToNumber;
import java.util.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ToNumberTests
extends RefineTest {
    private static final Double EPSILON = 1.0E-6;
    static Properties bindings = new Properties();

    @Test
    public void testConversions() {
        ToNumber f = new ToNumber();
        Assert.assertEquals((Object)f.call(bindings, new Object[]{11L}), (Object)11L);
        Assert.assertEquals((Object)f.call(bindings, new Object[]{"12"}), (Object)12L);
        Assert.assertTrue(((Double)f.call(bindings, new Object[]{"12345.6789"}) - Double.valueOf(12345.6789) < EPSILON ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(f.call(bindings, new Object[]{"abc"}) instanceof EvalError));
    }

    @Test
    public void testToNumber() {
        Assert.assertTrue((boolean)(ToNumberTests.invoke("toNumber", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(ToNumberTests.invoke("toNumber", new Object[]{null}) instanceof EvalError));
        Assert.assertTrue((boolean)(ToNumberTests.invoke("toNumber", "") instanceof EvalError));
        Assert.assertTrue((boolean)(ToNumberTests.invoke("toNumber", "string") instanceof EvalError));
        Assert.assertEquals((Object)ToNumberTests.invoke("toNumber", "0.0"), (Object)0.0);
        Assert.assertEquals((Object)ToNumberTests.invoke("toNumber", "123"), (Object)123L);
        Assert.assertTrue((Math.abs((Double)ToNumberTests.invoke("toNumber", "123.456") - 123.456) < EPSILON ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)ToNumberTests.invoke("toNumber", "001.234") - 1.234) < EPSILON ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)ToNumberTests.invoke("toNumber", "1e2") - 100.0) < EPSILON ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((Double)ToNumberTests.invoke("toNumber", Double.parseDouble("100.0")) - 100.0) < EPSILON ? 1 : 0) != 0);
    }
}

