/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.refine.expr.util.JsonValueConverter;
import com.google.refine.util.ParsingUtilities;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonValueConverterTests {
    private void fieldEquals(String json, Object expectedValue) {
        try {
            ObjectNode n = (ObjectNode)ParsingUtilities.mapper.readTree(json);
            Assert.assertEquals((Object)expectedValue, (Object)JsonValueConverter.convert((JsonNode)n.get("foo")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testConvertJsonObject() throws IOException {
        this.fieldEquals("{\"foo\":{\"ob\":\"ject\"}}", ParsingUtilities.mapper.readTree("{\"ob\":\"ject\"}"));
    }

    @Test
    public void testConvertJsonArray() throws IOException {
        this.fieldEquals("{\"foo\":[1,2]}", ParsingUtilities.mapper.readTree("[1,2]"));
    }

    @Test
    public void testConvertInt() {
        this.fieldEquals("{\"foo\":3}", 3);
    }

    @Test
    public void testConvertFloat() {
        this.fieldEquals("{\"foo\":3.14}", 3.14);
    }

    @Test
    public void testConvertBool() {
        this.fieldEquals("{\"foo\":true}", true);
    }

    @Test
    public void testConvertNull() {
        this.fieldEquals("{\"foo\":null}", null);
    }

    @Test
    public void testConvertString() {
        this.fieldEquals("{\"foo\":\"bar\"}", "bar");
    }

    @Test
    public void testConvertNoField() {
        this.fieldEquals("{}", null);
    }
}

