/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel;

import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Function;
import com.google.refine.model.Cell;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Row;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class FunctionTests
extends RefineTest {
    Project project;
    Engine engine;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws IOException, ModelException {
        this.project = this.createProjectWithColumns("FunctionTests", "Column A");
        bindings = new Properties();
        bindings.put("project", this.project);
        for (int i = 0; i < 10; ++i) {
            Row row = new Row(1);
            row.setCell(0, new Cell((Serializable)(i < 5 ? "a" : new Integer(1)), null));
            this.project.rows.add(row);
        }
    }

    @Override
    @AfterMethod
    public void TearDown() {
        bindings = null;
    }

    @Test
    public void testInvalidParams() {
        Assert.assertTrue((boolean)(FunctionTests.invoke("facetCount", new Object[0]) instanceof EvalError));
        Assert.assertTrue((boolean)(FunctionTests.invoke("facetCount", "one", "two", "three") instanceof EvalError));
        Assert.assertTrue((boolean)(FunctionTests.invoke("facetCount", "one", "bad(", "Column A") instanceof EvalError));
    }

    @Test
    public void testFacetCount() {
        Assert.assertEquals((Object)FunctionTests.invoke("facetCount", "a", "value", "Column A"), (Object)5);
        Assert.assertEquals((Object)FunctionTests.invoke("facetCount", new Integer(1), "value", "Column A"), (Object)5);
        Assert.assertEquals((Object)FunctionTests.invoke("facetCount", new Integer(2), "value+1", "Column A"), (Object)5);
    }

    @Test
    void testZeroArgs() {
        HashSet<String> valid0args = new HashSet<String>(Arrays.asList("now", "random", "randomNumber"));
        HashSet<String> returnsNull = new HashSet<String>(Arrays.asList("chomp", "contains", "escape", "unescape", "fingerprint", "get", "parseJson", "partition", "rpartition", "slice", "substring", "unicode", "unicodeType"));
        HashSet<String> returnsFalse = new HashSet<String>(Arrays.asList("hasField"));
        for (Map.Entry entry : ControlFunctionRegistry.getFunctionMapping()) {
            Function func = (Function)entry.getValue();
            Object result = func.call(bindings, new Object[0]);
            if (returnsNull.contains(ControlFunctionRegistry.getFunctionName((Function)func))) {
                Assert.assertNull((Object)result, (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't return null on 0 args"));
                continue;
            }
            if (returnsFalse.contains(ControlFunctionRegistry.getFunctionName((Function)func))) {
                Assert.assertEquals((Object)result, (Object)Boolean.FALSE, (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't return false on 0 args"));
                continue;
            }
            if (valid0args.contains(ControlFunctionRegistry.getFunctionName((Function)func))) continue;
            Assert.assertTrue((boolean)(result instanceof EvalError), (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't error on 0 args"));
        }
    }

    @Test
    void testTooManyArgs() {
        HashSet<String> returnsNull = new HashSet<String>(Arrays.asList("chomp", "contains", "coalesce", "escape", "unescape", "fingerprint", "get", "now", "parseJson", "partition", "rpartition", "slice", "substring", "unicode", "unicodeType"));
        HashSet<String> returnsFalse = new HashSet<String>(Arrays.asList("hasField"));
        HashSet<String> exempt = new HashSet<String>(Arrays.asList("jsonize"));
        for (Map.Entry entry : ControlFunctionRegistry.getFunctionMapping()) {
            Function func = (Function)entry.getValue();
            Object result = func.call(bindings, new Object[]{null, null, null, null, null, null, null, null});
            if (returnsNull.contains(ControlFunctionRegistry.getFunctionName((Function)func))) {
                Assert.assertNull((Object)result, (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't return null on 8 args"));
                continue;
            }
            if (returnsFalse.contains(ControlFunctionRegistry.getFunctionName((Function)func))) {
                Assert.assertEquals((Object)result, (Object)Boolean.FALSE, (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't return false on 8 args"));
                continue;
            }
            if (exempt.contains(ControlFunctionRegistry.getFunctionName((Function)func))) continue;
            Assert.assertTrue((boolean)(result instanceof EvalError), (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't error on 8 args"));
        }
    }

    @Test
    void testNullArgsMath() {
        HashSet<String> oneArgs = new HashSet<String>(Arrays.asList("abs", "acos", "asin", "atan", "ceil", "combin", "cos", "cosh", "degrees", "even", "exp", "fact", "floor", "ln", "log", "multinomial", "odd", "radians", "round", "sin", "sinh", "sum", "tan", "tanh"));
        HashSet<String> twoArgs = new HashSet<String>(Arrays.asList("atan2", "factn", "greatestCommonDenominator", "leastCommonMultiple", "max", "min", "mod", "pow", "quotient", "randomNumber"));
        for (Map.Entry entry : ControlFunctionRegistry.getFunctionMapping()) {
            Function func = (Function)entry.getValue();
            if (oneArgs.contains(ControlFunctionRegistry.getFunctionName((Function)func))) {
                Object result = func.call(bindings, new Object[]{null});
                Assert.assertTrue((boolean)(result instanceof EvalError), (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't error on null arg"));
                continue;
            }
            if (!twoArgs.contains(ControlFunctionRegistry.getFunctionName((Function)func))) continue;
            Object result2 = func.call(bindings, new Object[]{null, null});
            Assert.assertTrue((boolean)(result2 instanceof EvalError), (String)(ControlFunctionRegistry.getFunctionName((Function)func) + " didn't error on null args"));
        }
    }
}

