/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel;

import com.google.refine.RefineTest;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.MetaParser;
import com.google.refine.expr.ParsingException;
import com.google.refine.model.Project;
import java.util.Properties;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class GrelTests
extends RefineTest {
    Project project;
    Properties bindings;
    private static String[] COMPARISON_OPERATORS = new String[]{"==", "!=", ">", "<", ">=", "<="};
    private static String[] INVALID_OPERATORS = new String[]{"=<", "=<", "**", "^", "!"};
    private static String[] NUMERIC_OPERATORS = new String[]{"+", "-", "*", "/", "%"};

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() {
        this.project = new Project();
        this.bindings = ExpressionUtils.createBindings((Project)this.project);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.project = null;
        this.bindings = null;
    }

    @Test
    public void testInvalidSyntax() {
        String[] tests;
        for (String test : tests = new String[]{"", "1-1-", "2**3", "value{datePart()", "value}datePart()", "value.datePart{}"}) {
            try {
                MetaParser.parse((String)("grel:" + test));
            }
            catch (ParsingException e) {
                continue;
            }
            Assert.fail((String)("Expression failed to generate parse syntax error: " + test));
        }
    }

    @Test
    public void testEvalError() {
        String[] tests;
        for (String test : tests = new String[]{"value.datePart()"}) {
            try {
                Evaluable eval = MetaParser.parse((String)("grel:" + test));
                Object result = eval.evaluate(this.bindings);
                Assert.assertTrue((boolean)(result instanceof EvalError));
            }
            catch (ParsingException e) {
                Assert.fail((String)("Unexpected parse failure: " + test));
            }
        }
    }

    @Test
    public void testMath() throws ParsingException {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"1", "1"}, {"-1", "-1"}, {"-1 * 2", "-2"}, {"1 + 1", "2"}, {"1 + 1 + 1", "3"}, {"1-1-1", "-1"}, {"1-2-3", "-4"}, {"1-(2-3)", "2"}, {"2*3", "6"}, {"2.0*3", "6.0"}, {"-2.0*3", "-6.0"}, {"3%2", "1"}, {"3/2", "1"}, {"3.0/2", "1.5"}, {"1==1", "true"}, {"1==2", "false"}, {"1!=2", "true"}, {"1!=1", "false"}, {"1>2", "false"}, {"1<2", "true"}, {"1>1", "false"}, {"1>=1", "true"}, {"1<=2", "true"}, {"2<=2", "true"}, {"3<=2", "false"}, {"1.0==1", "true"}, {"1.0==2", "false"}, {"1.0>2", "false"}, {"1.0<2", "true"}, {"1.0>1", "false"}, {"1.0>=1", "true"}, {"1.0<=2", "true"}, {"2.0<=2", "true"}, {"3.0<=2", "false"}, {"0/0", "NaN"}, {"1.0/0.0", "Infinity"}, {"-1.0/0.0", "-Infinity"}, {"fact(4)", "24"}, {"fact(20)", "2432902008176640000"}, {"fact(21)", "java.lang.ArithmeticException: Integer overflow computing factorial"}, {"multinomial(1, 3)", "4"}, {"multinomial(0, 4)", "1"}, {"multinomial(18, 2)", "190"}, {"multinomial(18, 3)", "1330"}, {"multinomial(3, 5, 2)", "2520"}}) {
            this.parseEval(this.bindings, test);
        }
    }

    @Test
    public void testPI() throws ParsingException {
        String[] test = new String[]{"PI", "3.141592653589793"};
        this.parseEval(this.bindings, test);
    }

    @Test
    public void testString() throws ParsingException {
        String[][] tests;
        for (String[] test : tests = new String[][]{{"'a' + 'b'", "ab"}, {"'1/1/1900'.toDate() + 1", null}, {"'1/1/1900'.toDate() + '1/1/1800'.toDate()", null}, {"'1/1/1900'.toDate() > '1/1/1800'.toDate()", "true"}, {"'1/1/1900'.toDate() >= '1/1/1800'.toDate()", "true"}, {"'1/1/1900'.toDate() < '1/1/1800'.toDate()", "false"}, {"'1/1/1900'.toDate() <= '1/1/1800'.toDate()", "false"}, {"'1/1/1900'.toDate() != '1/1/1800'.toDate()", "true"}, {"'1/1/1900'.toDate() == '1/1/1800'.toDate()", "false"}, {"'1/1/1900'.toDate() == '1/1/1900'.toDate()", "true"}, {"'1/1/1900'.toDate() >= '1/1/1900'.toDate()", "true"}, {"'1/1/1900'.toDate() <= '1/1/1900'.toDate()", "true"}, {"'1/1/1900'.toDate() + ' foo'", "1900-01-01T00:00Z foo"}, {"1 + ' foo'", "1 foo"}, {"1.0 + ' foo'", "1.0 foo"}, {"2 * 3.0 + ' foo'", "6.0 foo"}, {"'a' > 'b'", "false"}, {"'a' < 'b'", "true"}, {"'a' == 'a'", "true"}, {"'a' == 'b'", "false"}, {"'a' != 'b'", "true"}, {"'E\u0301' == '\u00c9'", "true"}}) {
            this.parseEval(this.bindings, test);
        }
    }

    @Test
    public void testJoinJsonArray() throws ParsingException {
        String[] test = new String[]{"\"{\\\"values\\\":[\\\"one\\\",\\\"two\\\",\\\"three\\\"]}\".parseJson().values.join(\",\")", "one,two,three"};
        this.parseEval(this.bindings, test);
    }

    @Test
    public void testGetFieldFromNull() throws ParsingException {
        String test = "null.value";
        Evaluable eval = MetaParser.parse((String)("grel:" + test));
        Assert.assertNull((Object)eval.evaluate(this.bindings));
    }

    @Test
    public void testCrossFunctionEval() {
        String test = "cross(\"Mary\", \"My Address Book\", \"friend\")";
        try {
            Evaluable eval = MetaParser.parse((String)("grel:" + test));
            Object result = eval.evaluate(this.bindings);
            Assert.assertTrue((boolean)(result instanceof EvalError));
        }
        catch (ParsingException e) {
            Assert.fail((String)("Unexpected parse failure for cross function: " + test));
        }
    }
}

