/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.importers;

import com.google.refine.importers.ImporterTest;
import com.google.refine.importers.ImportingParserBase;
import com.google.refine.importers.LineBasedImporter;
import com.google.refine.model.Cell;
import com.google.refine.model.Column;
import com.google.refine.model.Row;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class LineBasedImporterTests
extends ImporterTest {
    LineBasedImporter SUT = null;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    @BeforeMethod
    public void setUp() {
        super.setUp();
        this.SUT = new LineBasedImporter();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.SUT = null;
        super.tearDown();
    }

    @Test
    public void readSimpleData_1Header_1Row() {
        String input = "col1\ndata1";
        try {
            this.prepareOptions("\\r?\\n", 1, 1, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.columnModel.columns.size(), (int)1);
        Assert.assertEquals((String)((Column)this.project.columnModel.columns.get(0)).getName(), (String)"col1");
        Assert.assertEquals((int)this.project.rows.size(), (int)1);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)1);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
    }

    @Test
    public void readMixedLineData() {
        String input = "data1\r\ndata2\ndata3\rdata4";
        try {
            this.prepareOptions("\\r?\\n", 1, 0, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)3);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)1);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"data1");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value, (Object)"data2");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)0)).value, (Object)"data3\rdata4");
    }

    @Test(dataProvider="LineBasedImporter-Separators")
    public void readLineData(String pattern, String sep) {
        String input = "dataa,datab,datac,datad".replace(",", sep);
        try {
            this.prepareOptions(pattern, 1, 0, false);
            this.parseOneFile((ImportingParserBase)this.SUT, (Reader)new StringReader(input));
        }
        catch (Exception e) {
            Assert.fail((String)"Exception during file parse", (Throwable)e);
        }
        Assert.assertEquals((int)this.project.rows.size(), (int)4);
        Assert.assertEquals((int)((Row)this.project.rows.get((int)0)).cells.size(), (int)1);
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)0)).cells.get((int)0)).value, (Object)"dataa");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)1)).cells.get((int)0)).value, (Object)"datab");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)2)).cells.get((int)0)).value, (Object)"datac");
        Assert.assertEquals((Object)((Cell)((Row)this.project.rows.get((int)3)).cells.get((int)0)).value, (Object)"datad");
    }

    @DataProvider(name="LineBasedImporter-Separators")
    public Object[][] LineBasedImporter_Separators() {
        return new Object[][]{{"\\r?\\n", "\n"}, {"\\\\*%%\\\\*", "*%%*"}, {",", ","}, {"[0-9]", "1"}};
    }

    protected void prepareOptions(String sep, int linesPerRow, int headerLines, boolean guessCellValueTypes) {
        LineBasedImporterTests.whenGetStringOption("separator", this.options, sep);
        LineBasedImporterTests.whenGetIntegerOption("linesPerRow", this.options, linesPerRow);
        LineBasedImporterTests.whenGetIntegerOption("headerLines", this.options, headerLines);
        LineBasedImporterTests.whenGetBooleanOption("guessCellValueTypes", this.options, guessCellValueTypes);
    }
}

