/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.operations.recon;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.refine.RefineTest;
import com.google.refine.browsing.Engine;
import com.google.refine.browsing.EngineConfig;
import com.google.refine.model.Cell;
import com.google.refine.model.ModelException;
import com.google.refine.model.Project;
import com.google.refine.model.Recon;
import com.google.refine.model.ReconCandidate;
import com.google.refine.model.Row;
import com.google.refine.model.recon.DataExtensionReconConfig;
import com.google.refine.model.recon.ReconConfig;
import com.google.refine.model.recon.ReconciledDataExtensionJob;
import com.google.refine.operations.OperationRegistry;
import com.google.refine.operations.recon.ExtendDataOperation;
import com.google.refine.process.LongRunningProcessStub;
import com.google.refine.process.Process;
import com.google.refine.util.ParsingUtilities;
import com.google.refine.util.TestUtils;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ExtendDataOperationTests
extends RefineTest {
    static final String ENGINE_JSON_URLS = "{\"mode\":\"row-based\"}}";
    static final String RECON_SERVICE = "https://tools.wmflabs.org/openrefine-wikidata/en/api";
    static final String RECON_IDENTIFIER_SPACE = "http://www.wikidata.org/entity/";
    static final String RECON_SCHEMA_SPACE = "http://www.wikidata.org/prop/direct/";
    private String dataExtensionConfigJson = "{    \"properties\":[        {\"name\":\"inception\",\"id\":\"P571\"},        {\"name\":\"headquarters location\",\"id\":\"P159\"},        {\"name\":\"coordinate location\",\"id\":\"P625\"}     ]}";
    private String operationJson = "{\"op\":\"core/extend-reconciled-data\",\"description\":\"Extend data at index 3 based on column organization_name\",\"engineConfig\":{\"mode\":\"row-based\",\"facets\":[    {\"selectNumeric\":true,\"expression\":\"cell.recon.best.score\",\"selectBlank\":false,\"selectNonNumeric\":true,\"selectError\":true,\"name\":\"organization_name: best candidate's score\",\"from\":13,\"to\":101,\"type\":\"range\",\"columnName\":\"organization_name\"},    {\"selectNonTime\":true,\"expression\":\"grel:toDate(value)\",\"selectBlank\":true,\"selectError\":true,\"selectTime\":true,\"name\":\"start_year\",\"from\":410242968000,\"to\":1262309184000,\"type\":\"timerange\",\"columnName\":\"start_year\"}]},\"columnInsertIndex\":3,\"baseColumnName\":\"organization_name\",\"endpoint\":\"https://tools.wmflabs.org/openrefine-wikidata/en/api\",\"identifierSpace\":\"http://www.wikidata.org/entity/\",\"schemaSpace\":\"http://www.wikidata.org/prop/direct/\",\"extension\":{    \"properties\":[        {\"name\":\"inception\",\"id\":\"P571\"},        {\"name\":\"headquarters location\",\"id\":\"P159\"},        {\"name\":\"coordinate location\",\"id\":\"P625\"}     ]}}";
    private String processJson = "    {\n       \"description\" : \"Extend data at index 3 based on column organization_name\",\n       \"id\" : %d,\n       \"immediate\" : false,\n       \"progress\" : 0,\n       \"status\" : \"pending\"\n     }";
    private Map<JsonNode, String> mockedResponses = new HashMap<JsonNode, String>();
    Project project;
    Properties options;
    EngineConfig engine_config;
    Engine engine;
    Dispatcher dispatcher;

    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @BeforeMethod
    public void SetUp() throws IOException, ModelException {
        OperationRegistry.registerOperation((ButterflyModule)this.getCoreModule(), (String)"extend-reconciled-data", ExtendDataOperation.class);
        this.project = this.createProjectWithColumns("DataExtensionTests", "country");
        this.project.columnModel.getColumnByName("country").setReconConfig((ReconConfig)new DataExtensionReconConfig(RECON_SERVICE, RECON_IDENTIFIER_SPACE, RECON_SCHEMA_SPACE, null));
        this.options = (Properties)Mockito.mock(Properties.class);
        this.engine = new Engine(this.project);
        this.engine_config = EngineConfig.reconstruct((String)ENGINE_JSON_URLS);
        this.engine.initializeFromConfig(this.engine_config);
        this.engine.setMode(Engine.Mode.RowBased);
        Row row = new Row(2);
        row.setCell(0, ExtendDataOperationTests.reconciledCell("Iran", "Q794"));
        this.project.rows.add(row);
        row = new Row(2);
        row.setCell(0, ExtendDataOperationTests.reconciledCell("Japan", "Q17"));
        this.project.rows.add(row);
        row = new Row(2);
        row.setCell(0, ExtendDataOperationTests.reconciledCell("Tajikistan", "Q863"));
        this.project.rows.add(row);
        row = new Row(2);
        row.setCell(0, ExtendDataOperationTests.reconciledCell("United States of America", "Q30"));
        this.project.rows.add(row);
        this.dispatcher = new Dispatcher(){

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                JsonNode parsedQuery;
                String json = URLDecoder.decode(request.getBody().readUtf8().split("=")[1], StandardCharsets.UTF_8);
                try {
                    parsedQuery = ParsingUtilities.mapper.readTree(json);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("HTTP call with invalid JSON payload: " + json);
                }
                if (ExtendDataOperationTests.this.mockedResponses.containsKey(parsedQuery)) {
                    return new MockResponse().setResponseCode(200).setBody(ExtendDataOperationTests.this.mockedResponses.get(parsedQuery));
                }
                throw new IllegalArgumentException("HTTP call not mocked for query: " + json);
            }
        };
    }

    @Test
    public void serializeExtendDataOperation() throws Exception {
        TestUtils.isSerializedTo(ParsingUtilities.mapper.readValue(this.operationJson, ExtendDataOperation.class), this.operationJson);
    }

    @Test
    public void serializeExtendDataProcess() throws Exception {
        Process p = ((ExtendDataOperation)ParsingUtilities.mapper.readValue(this.operationJson, ExtendDataOperation.class)).createProcess(this.project, new Properties());
        TestUtils.isSerializedTo(p, String.format(this.processJson, p.hashCode()));
    }

    @Test
    public void serializeDataExtensionConfig() throws IOException {
        TestUtils.isSerializedTo(ReconciledDataExtensionJob.DataExtensionConfig.reconstruct((String)this.dataExtensionConfigJson), this.dataExtensionConfigJson);
    }

    @Test
    public void testFormulateQuery() throws IOException {
        ReconciledDataExtensionJob.DataExtensionConfig config = ReconciledDataExtensionJob.DataExtensionConfig.reconstruct((String)this.dataExtensionConfigJson);
        Set<String> ids = Collections.singleton("Q2");
        String json = "{\"ids\":[\"Q2\"],\"properties\":[{\"id\":\"P571\"},{\"id\":\"P159\"},{\"id\":\"P625\"}]}";
        ReconciledDataExtensionJobStub stub = new ReconciledDataExtensionJobStub(config, "http://endpoint");
        TestUtils.assertEqualsAsJson(stub.formulateQueryStub(ids, config), json);
    }

    @Override
    @AfterMethod
    public void TearDown() {
        this.project = null;
        this.options = null;
        this.engine = null;
    }

    public static Cell reconciledCell(String name, String id) {
        ReconCandidate r = new ReconCandidate(id, name, new String[0], 100.0);
        ArrayList<ReconCandidate> candidates = new ArrayList<ReconCandidate>();
        candidates.add(r);
        Recon rec = new Recon(0L, RECON_IDENTIFIER_SPACE, RECON_SCHEMA_SPACE);
        rec.service = RECON_SERVICE;
        rec.candidates = candidates;
        rec.match = r;
        return new Cell((Serializable)((Object)name), rec);
    }

    @AfterMethod
    public void cleanupHttpMocks() {
        this.mockedResponses.clear();
    }

    @Test
    public void testFetchStrings() throws Exception {
        ReconciledDataExtensionJob.DataExtensionConfig extension = ReconciledDataExtensionJob.DataExtensionConfig.reconstruct((String)"{\"properties\":[{\"id\":\"P297\",\"name\":\"ISO 3166-1 alpha-2 code\"}]}");
        try (MockWebServer server = new MockWebServer();){
            server.start();
            server.setDispatcher(this.dispatcher);
            this.mockHttpCall("{\"ids\":[\"Q863\",\"Q794\",\"Q17\",\"Q30\"],\"properties\":[{\"id\":\"P297\"}]}", "{\"rows\": {    \"Q794\": {\"P297\": [{\"str\": \"IR\"}]},    \"Q863\": {\"P297\": []},    \"Q30\": {\"P297\": [{\"str\": \"US\"}]},    \"Q17\": {\"P297\": [{\"str\": \"JP\"}]}},\"meta\": [   {\"name\": \"ISO 3166-1 alpha-2 code\", \"id\": \"P297\"}]}");
            ExtendDataOperation op = new ExtendDataOperation(this.engine_config, "country", server.url("/reconcile").url().toString(), RECON_IDENTIFIER_SPACE, RECON_SCHEMA_SPACE, extension, 1);
            LongRunningProcessStub process = new LongRunningProcessStub(op.createProcess(this.project, this.options));
            process.run();
            Assert.assertTrue((boolean)"IR".equals(((Row)this.project.rows.get(0)).getCellValue(1)), (String)"Bad country code for Iran.");
            Assert.assertTrue((boolean)"JP".equals(((Row)this.project.rows.get(1)).getCellValue(1)), (String)"Bad country code for Japan.");
            Assert.assertNull((Object)((Row)this.project.rows.get(2)).getCell(1), (String)"Expected a null country code.");
            Assert.assertTrue((boolean)"US".equals(((Row)this.project.rows.get(3)).getCellValue(1)), (String)"Bad country code for United States.");
            Assert.assertTrue((this.project.columnModel.getColumnByName("ISO 3166-1 alpha-2 code").getReconStats() == null ? 1 : 0) != 0);
            Assert.assertTrue((this.project.columnModel.getColumnByName("ISO 3166-1 alpha-2 code").getSourceReconConfig() != null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFetchCounts() throws Exception {
        ReconciledDataExtensionJob.DataExtensionConfig extension = ReconciledDataExtensionJob.DataExtensionConfig.reconstruct((String)"{\"properties\":[{\"id\":\"P38\",\"name\":\"currency\",\"settings\":{\"count\":\"on\",\"rank\":\"any\"}}]}");
        this.mockHttpCall("{\"ids\":[\"Q863\",\"Q794\",\"Q17\",\"Q30\"],\"properties\":[{\"id\":\"P38\",\"settings\":{\"count\":\"on\",\"rank\":\"any\"}}]}", "{\"rows\": {    \"Q794\": {\"P38\": [{\"float\": 1}]},    \"Q863\": {\"P38\": [{\"float\": 2}]},    \"Q30\": {\"P38\": [{\"float\": 1}]},    \"Q17\": {\"P38\": [{\"float\": 1}]}},\"meta\": [    {\"settings\": {\"count\": \"on\", \"rank\": \"any\"}, \"name\": \"currency\", \"id\": \"P38\"}]}");
        try (MockWebServer server = new MockWebServer();){
            server.start();
            server.setDispatcher(this.dispatcher);
            ExtendDataOperation op = new ExtendDataOperation(this.engine_config, "country", server.url("/reconcile").url().toString(), RECON_IDENTIFIER_SPACE, RECON_SCHEMA_SPACE, extension, 1);
            LongRunningProcessStub process = new LongRunningProcessStub(op.createProcess(this.project, this.options));
            process.run();
            Assert.assertTrue((Math.round((Double)((Row)this.project.rows.get(2)).getCellValue(1)) == 2L ? 1 : 0) != 0, (String)"Incorrect number of currencies returned for Tajikistan.");
            Assert.assertTrue((Math.round((Double)((Row)this.project.rows.get(3)).getCellValue(1)) == 1L ? 1 : 0) != 0, (String)"Incorrect number of currencies returned for United States.");
            Assert.assertTrue((this.project.columnModel.getColumnByName("currency").getReconStats() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFetchCurrent() throws Exception {
        ReconciledDataExtensionJob.DataExtensionConfig extension = ReconciledDataExtensionJob.DataExtensionConfig.reconstruct((String)"{\"properties\":[{\"id\":\"P38\",\"name\":\"currency\",\"settings\":{\"rank\":\"best\"}}]}");
        this.mockHttpCall("{\"ids\":[\"Q863\",\"Q794\",\"Q17\",\"Q30\"],\"properties\":[{\"id\":\"P38\",\"settings\":{\"rank\":\"best\"}}]}", "{\"rows\":{   \"Q794\": {\"P38\": [{\"name\": \"Iranian rial\", \"id\": \"Q188608\"}]},   \"Q863\": {\"P38\": [{\"name\": \"Tajikistani somoni\", \"id\": \"Q199886\"}]},   \"Q30\": {\"P38\": [{\"name\": \"United States dollar\", \"id\": \"Q4917\"}]},   \"Q17\": {\"P38\": [{\"name\": \"Japanese yen\", \"id\": \"Q8146\"}]}}, \"meta\": [     {\"settings\": {\"rank\": \"best\"}, \"name\": \"currency\", \"id\": \"P38\"}]}");
        try (MockWebServer server = new MockWebServer();){
            server.start();
            server.setDispatcher(this.dispatcher);
            ExtendDataOperation op = new ExtendDataOperation(this.engine_config, "country", server.url("/reconcile").url().toString(), RECON_IDENTIFIER_SPACE, RECON_SCHEMA_SPACE, extension, 1);
            LongRunningProcessStub process = new LongRunningProcessStub(op.createProcess(this.project, this.options));
            process.run();
            Assert.assertTrue((boolean)"Tajikistani somoni".equals(((Row)this.project.rows.get(2)).getCellValue(1)));
            Assert.assertTrue((boolean)"United States dollar".equals(((Row)this.project.rows.get(3)).getCellValue(1)));
            Assert.assertTrue((this.project.columnModel.getColumnByName((String)"currency").getReconStats().matchedTopics == 4 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFetchRecord() throws Exception {
        ReconciledDataExtensionJob.DataExtensionConfig extension = ReconciledDataExtensionJob.DataExtensionConfig.reconstruct((String)"{\"properties\":[{\"id\":\"P38\",\"name\":\"currency\",\"settings\":{\"rank\":\"any\"}}]}");
        this.mockHttpCall("{\"ids\":[\"Q863\",\"Q794\",\"Q17\",\"Q30\"],\"properties\":[{\"id\":\"P38\",\"settings\":{\"rank\":\"any\"}}]}", "{\"rows\": {   \"Q794\": {\"P38\": [{\"name\": \"Iranian rial\", \"id\": \"Q188608\"}]},   \"Q863\": {\"P38\": [{\"name\": \"Tajikistani somoni\", \"id\": \"Q199886\"}, {\"name\": \"Tajikistani ruble\", \"id\": \"Q2423956\"}]},   \"Q30\": {\"P38\": [{\"name\": \"United States dollar\", \"id\": \"Q4917\"}]},   \"Q17\": {\"P38\": [{\"name\": \"Japanese yen\", \"id\": \"Q8146\"}]}},\"meta\": [    {\"settings\": {\"rank\": \"any\"}, \"name\": \"currency\", \"id\": \"P38\"}]}");
        try (MockWebServer server = new MockWebServer();){
            server.start();
            server.setDispatcher(this.dispatcher);
            ExtendDataOperation op = new ExtendDataOperation(this.engine_config, "country", server.url("/reconcile").url().toString(), RECON_IDENTIFIER_SPACE, RECON_SCHEMA_SPACE, extension, 1);
            LongRunningProcessStub process = new LongRunningProcessStub(op.createProcess(this.project, this.options));
            process.run();
            Assert.assertTrue((boolean)"Tajikistani somoni".equals(((Row)this.project.rows.get(2)).getCellValue(1)), (String)"Bad currency name for Tajikistan");
            Assert.assertTrue((boolean)"Tajikistani ruble".equals(((Row)this.project.rows.get(3)).getCellValue(1)), (String)"Bad currency name for Tajikistan");
            Assert.assertTrue((null == ((Row)this.project.rows.get(3)).getCellValue(0) ? 1 : 0) != 0);
            Assert.assertTrue((this.project.columnModel.getColumnByName((String)"currency").getReconStats().matchedTopics == 5 ? 1 : 0) != 0);
        }
    }

    private void mockHttpCall(String query, String response) throws IOException {
        this.mockedResponses.put(ParsingUtilities.mapper.readTree(query), response);
    }

    String fakeHttpCall(String endpoint, String query) throws IOException {
        JsonNode parsedQuery = ParsingUtilities.mapper.readTree(query);
        if (this.mockedResponses.containsKey(parsedQuery)) {
            return this.mockedResponses.get(parsedQuery);
        }
        throw new IllegalArgumentException("HTTP call not mocked for query: " + query);
    }

    public static class ReconciledDataExtensionJobStub
    extends ReconciledDataExtensionJob {
        public ReconciledDataExtensionJobStub(ReconciledDataExtensionJob.DataExtensionConfig obj, String endpoint) {
            super(obj, endpoint);
        }

        public String formulateQueryStub(Set<String> ids, ReconciledDataExtensionJob.DataExtensionConfig node) throws IOException {
            StringWriter writer = new StringWriter();
            ReconciledDataExtensionJob.formulateQuery(ids, (ReconciledDataExtensionJob.DataExtensionConfig)node, (Writer)writer);
            return writer.toString();
        }
    }
}

