/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.process;

import com.google.refine.ProjectManager;
import com.google.refine.ProjectMetadata;
import com.google.refine.RefineTest;
import com.google.refine.history.Change;
import com.google.refine.history.HistoryEntry;
import com.google.refine.history.HistoryProcess;
import com.google.refine.model.AbstractOperation;
import com.google.refine.model.Project;
import com.google.refine.util.TestUtils;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HistoryProcessTests
extends RefineTest {
    private Project project;
    private ProjectMetadata projectMetadata;

    @BeforeMethod
    public void setUp() {
        this.project = new Project();
        this.projectMetadata = (ProjectMetadata)Mockito.mock(ProjectMetadata.class);
        ProjectManager.singleton.registerProject(this.project, this.projectMetadata);
        AbstractOperation op = (AbstractOperation)Mockito.mock(AbstractOperation.class);
        Change ch = (Change)Mockito.mock(Change.class);
        HistoryEntry entry = new HistoryEntry(1234L, this.project, "first operation", op, ch);
        this.project.history.addEntry(entry);
        entry = new HistoryEntry(5678L, this.project, "second operation", op, ch);
        this.project.history.addEntry(entry);
    }

    @Test
    public void serializeHistoryProcess() {
        HistoryProcess process = new HistoryProcess(this.project, 1234L);
        TestUtils.isSerializedTo(process, "{\"description\":\"Undo/redo until after first operation\",\"immediate\":true,\"status\":\"pending\"}");
    }
}

