/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.google.refine.RefineTest;
import com.google.refine.util.ParsingUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ParsingUtilitiesTests
extends RefineTest {
    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void zonedDateTimeTest() {
        String d = "2017-12-01T14:53:36Z";
        DateTimeFormatter formatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        OffsetDateTime.parse(d, formatter);
    }

    @Test
    public void parseProjectBeforeJDK8() {
        String historyEntryDate = "2017-12-01T14:53:36Z";
        OffsetDateTime zdt = ParsingUtilities.stringToDate((String)historyEntryDate);
        String zdtString = ParsingUtilities.dateToString((OffsetDateTime)zdt);
        Assert.assertEquals((String)zdtString, (String)historyEntryDate);
    }

    @Test
    public void stringToDate() {
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToDate((String)"2017-04-03T08:09:43.123").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToDate((String)"2017-04-03T08:09:43").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToDate((String)"2017-04-03T08:09:43Z").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToDate((String)"2017-04-03T08:09:43.123Z").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToDate((String)"2017-04-03T08:09:43+00:00").getYear());
    }

    @Test
    public void stringToLocalDate() {
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToLocalDate((String)"2017-04-03T08:09:43.123").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToLocalDate((String)"2017-04-03T08:09:43").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToLocalDate((String)"2017-04-03T08:09:43Z").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToLocalDate((String)"2017-04-03T08:09:43.123Z").getYear());
        Assert.assertEquals((int)2017, (int)ParsingUtilities.stringToLocalDate((String)"2017-04-03T08:09:43+00:00").getYear());
    }

    @Test
    public void stringToLocalDateNonUTC() {
        TimeZone originalTimeZone = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone("JST"));
            Assert.assertEquals((int)ParsingUtilities.stringToLocalDate((String)"2001-08-12T00:00:00Z").getHour(), (int)9);
            Assert.assertEquals((String)ParsingUtilities.localDateToString((LocalDateTime)ParsingUtilities.stringToLocalDate((String)"2001-08-12T00:00:00Z")), (String)"2001-08-12T00:00:00Z");
        }
        finally {
            TimeZone.setDefault(originalTimeZone);
        }
    }

    @Test
    public void testParseGZIPInutstream() throws IOException {
        try {
            String sampleBody = "<HTML>\n\n<HEAD>\n\n<TITLE>Your Title Here</TITLE>\n\n</HEAD>\n\n<BODY BGCOLOR=\"FFFFFF\">\n\n</BODY>\n\n</HTML>";
            ByteArrayOutputStream obj = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            gzip.write(sampleBody.getBytes("UTF-8"));
            gzip.close();
            byte[] compressed = obj.toByteArray();
            String res = ParsingUtilities.inputStreamToString((InputStream)new ByteArrayInputStream(compressed), (String)"gzip");
            Assert.assertEquals((String)res, (String)sampleBody);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

