/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.util;

import com.google.refine.RefineTest;
import com.google.refine.util.PatternSyntaxExceptionParser;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class PatternSyntaxExceptionParserTests
extends RefineTest {
    @Override
    @BeforeTest
    public void init() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void unmatchedOpeningParenthesisTest() {
        String s = "(abc";
        try {
            Pattern.compile(s);
            Assert.assertTrue((boolean)false, (String)"Test pattern successfully compiled when it should fail");
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression is missing a closing ')' character.");
        }
    }

    @Test
    public void unmatchedClosingParenthesisTest() {
        String s = "abc)";
        try {
            Pattern.compile(s);
            Assert.assertTrue((boolean)false, (String)"Test pattern successfully compiled when it should fail");
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression is missing a opening '(' character.");
        }
    }

    @Test
    public void unmatchedOpeningSquareBracketTest() {
        String s = "[abc";
        try {
            Pattern.compile(s);
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression is missing a closing ']' character, or has an empty pair of square brackets '[]'.");
        }
    }

    @Test
    public void danglingBackslashTest() {
        String s = "abc\\";
        try {
            Pattern.compile(s);
            Assert.assertTrue((boolean)false, (String)"Test pattern successfully compiled when it should fail");
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression has a backslash '\\' at the end.");
        }
    }

    @Test
    public void unmatchedOpeningCurlyBracketTest() {
        String s = "abc{3";
        try {
            Pattern.compile(s);
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression is missing a closing '}' character, or has an incorrect quantifier statement in curly brackets '{}'.");
        }
    }

    @Test
    public void illegalQuantifierStatement() {
        String s = "abc{";
        try {
            Pattern.compile(s);
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression has an incomplete or incorrect quantifier statement in curly brackets '{}'.");
        }
    }

    @Test
    public void quantifierTargetValidityTest() {
        String s = "abc+*";
        try {
            Pattern.compile(s);
            Assert.assertTrue((boolean)false, (String)"Test pattern successfully compiled when it should fail");
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression has a '*','+' or '?' in the wrong place.");
        }
    }

    @Test
    public void quantifierMagnitudeTest() {
        String s = "a{4,3}";
        try {
            Pattern.compile(s);
            Assert.assertTrue((boolean)false, (String)"Test pattern successfully compiled when it should fail");
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression has a quantifier statement where the minimum is larger than the maximum (e.g. {4,3}).");
        }
    }

    @Test
    public void rangeOrderTest() {
        String s = "abc[9-0]";
        try {
            Pattern.compile(s);
            Assert.assertTrue((boolean)false, (String)"Test pattern successfully compiled when it should fail");
        }
        catch (PatternSyntaxException err) {
            PatternSyntaxExceptionParser e = new PatternSyntaxExceptionParser(err);
            Assert.assertEquals((String)e.getUserMessage(), (String)"The regular expression has a range statement which is incomplete or has the characters in the incorrect order (e.g. [9-0])");
        }
    }
}

