// CHECKSTYLE:OFF

package com.google.refine.operations;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
public class OperationDescription {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(OperationDescription.class);

    /**
     * Key {@code column_split_brief}: {@code Split column {0} by field
     * lengths}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Split column {0} by field lengths}
     */
    public static String column_split_brief(Object arg0) {
        return holder.format("column_split_brief", arg0);
    }

    /**
     * Key {@code column_split_brief}: {@code Split column {0} by field
     * lengths}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Split column {0} by field lengths}
     */
    public static Localizable _column_split_brief(Object arg0) {
        return new Localizable(holder, "column_split_brief", arg0);
    }

    /**
     * Key {@code recon_match_best_candidates_desc}: {@code Match each of {0}
     * cells to its best candidate in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match each of {0} cells to its best candidate in column {1}}
     */
    public static String recon_match_best_candidates_desc(Object arg0, Object arg1) {
        return holder.format("recon_match_best_candidates_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_match_best_candidates_desc}: {@code Match each of {0}
     * cells to its best candidate in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match each of {0} cells to its best candidate in column {1}}
     */
    public static Localizable _recon_match_best_candidates_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_match_best_candidates_desc", arg0, arg1);
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_combined_neg_brief}:
     * {@code Transpose cells in columns starting with {0} into rows in one
     * new column named {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in columns starting with {0} into rows in one
     *     new column named {1}}
     */
    public static String cell_transpose_columns_into_rows_combined_neg_brief(Object arg0, Object arg1) {
        return holder.format("cell_transpose_columns_into_rows_combined_neg_brief", arg0, arg1);
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_combined_neg_brief}:
     * {@code Transpose cells in columns starting with {0} into rows in one
     * new column named {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in columns starting with {0} into rows in one
     *     new column named {1}}
     */
    public static Localizable _cell_transpose_columns_into_rows_combined_neg_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "cell_transpose_columns_into_rows_combined_neg_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_use_values_as_identifiers_brief}: {@code Use values
     * as reconciliation identifiers in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use values as reconciliation identifiers in column {0}}
     */
    public static String recon_use_values_as_identifiers_brief(Object arg0) {
        return holder.format("recon_use_values_as_identifiers_brief", arg0);
    }

    /**
     * Key {@code recon_use_values_as_identifiers_brief}: {@code Use values
     * as reconciliation identifiers in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use values as reconciliation identifiers in column {0}}
     */
    public static Localizable _recon_use_values_as_identifiers_brief(Object arg0) {
        return new Localizable(holder, "recon_use_values_as_identifiers_brief", arg0);
    }

    /**
     * Key {@code recon_judge_similar_cells_none_brief}: {@code Discard recon
     * judgments for cells containing "{0}" in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for cells containing "{0}" in column
     *     {1}}
     */
    public static String recon_judge_similar_cells_none_brief(Object arg0, Object arg1) {
        return holder.format("recon_judge_similar_cells_none_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_judge_similar_cells_none_brief}: {@code Discard recon
     * judgments for cells containing "{0}" in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for cells containing "{0}" in column
     *     {1}}
     */
    public static Localizable _recon_judge_similar_cells_none_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_judge_similar_cells_none_brief", arg0, arg1);
    }

    /**
     * Key {@code cell_blank_down_desc}: {@code Blank down {0} cells in
     * column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blank down {0} cells in column {1}}
     */
    public static String cell_blank_down_desc(Object arg0, Object arg1) {
        return holder.format("cell_blank_down_desc", arg0, arg1);
    }

    /**
     * Key {@code cell_blank_down_desc}: {@code Blank down {0} cells in
     * column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blank down {0} cells in column {1}}
     */
    public static Localizable _cell_blank_down_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "cell_blank_down_desc", arg0, arg1);
    }

    /**
     * Key {@code column_removal_brief}: {@code Remove column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Remove column {0}}
     */
    public static String column_removal_brief(Object arg0) {
        return holder.format("column_removal_brief", arg0);
    }

    /**
     * Key {@code column_removal_brief}: {@code Remove column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Remove column {0}}
     */
    public static Localizable _column_removal_brief(Object arg0) {
        return new Localizable(holder, "column_removal_brief", arg0);
    }

    /**
     * Key {@code recon_match_specific_topic_desc}: {@code Match specific
     * item {0} ({1}) to {2} cells in column {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match specific item {0} ({1}) to {2} cells in column {3}}
     */
    public static String recon_match_specific_topic_desc(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("recon_match_specific_topic_desc", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code recon_match_specific_topic_desc}: {@code Match specific
     * item {0} ({1}) to {2} cells in column {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match specific item {0} ({1}) to {2} cells in column {3}}
     */
    public static Localizable _recon_match_specific_topic_desc(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "recon_match_specific_topic_desc", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code cell_fill_down_desc}: {@code Fill down {0} cells in column
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fill down {0} cells in column {1}}
     */
    public static String cell_fill_down_desc(Object arg0, Object arg1) {
        return holder.format("cell_fill_down_desc", arg0, arg1);
    }

    /**
     * Key {@code cell_fill_down_desc}: {@code Fill down {0} cells in column
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fill down {0} cells in column {1}}
     */
    public static Localizable _cell_fill_down_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "cell_fill_down_desc", arg0, arg1);
    }

    /**
     * Key {@code column_rename_brief}: {@code Rename column {0} to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Rename column {0} to {1}}
     */
    public static String column_rename_brief(Object arg0, Object arg1) {
        return holder.format("column_rename_brief", arg0, arg1);
    }

    /**
     * Key {@code column_rename_brief}: {@code Rename column {0} to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Rename column {0} to {1}}
     */
    public static Localizable _column_rename_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "column_rename_brief", arg0, arg1);
    }

    /**
     * Key {@code row_unflag_brief}: {@code Unflag rows}.
     * 
     * @return
     *     {@code Unflag rows}
     */
    public static String row_unflag_brief() {
        return holder.format("row_unflag_brief");
    }

    /**
     * Key {@code row_unflag_brief}: {@code Unflag rows}.
     * 
     * @return
     *     {@code Unflag rows}
     */
    public static Localizable _row_unflag_brief() {
        return new Localizable(holder, "row_unflag_brief");
    }

    /**
     * Key {@code recon_judge_similar_cells_new_desc}: {@code Mark to create
     * one new item for each of {0} cell containing {1} in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one new item for each of {0} cell containing {1}
     *     in column {2}}
     */
    public static String recon_judge_similar_cells_new_desc(Object arg0, Object arg1, Object arg2) {
        return holder.format("recon_judge_similar_cells_new_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_judge_similar_cells_new_desc}: {@code Mark to create
     * one new item for each of {0} cell containing {1} in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one new item for each of {0} cell containing {1}
     *     in column {2}}
     */
    public static Localizable _recon_judge_similar_cells_new_desc(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "recon_judge_similar_cells_new_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_judge_similar_cells_new_brief}: {@code Mark to create
     * one new item for each cell containing {0} in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one new item for each cell containing {0} in
     *     column {1}}
     */
    public static String recon_judge_similar_cells_new_brief(Object arg0, Object arg1) {
        return holder.format("recon_judge_similar_cells_new_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_judge_similar_cells_new_brief}: {@code Mark to create
     * one new item for each cell containing {0} in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one new item for each cell containing {0} in
     *     column {1}}
     */
    public static Localizable _recon_judge_similar_cells_new_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_judge_similar_cells_new_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_extend_data_desc}: {@code Extend data at index {0}
     * based on column {1} by filling {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Extend data at index {0} based on column {1} by filling {2}}
     */
    public static String recon_extend_data_desc(Object arg0, Object arg1, Object arg2) {
        return holder.format("recon_extend_data_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_extend_data_desc}: {@code Extend data at index {0}
     * based on column {1} by filling {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Extend data at index {0} based on column {1} by filling {2}}
     */
    public static Localizable _recon_extend_data_desc(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "recon_extend_data_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_copy_across_columns_desc}: {@code Copy {0} recon
     * judgments from column {1} to {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copy {0} recon judgments from column {1} to {2}}
     */
    public static String recon_copy_across_columns_desc(Object arg0, Object arg1, Object arg2) {
        return holder.format("recon_copy_across_columns_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_copy_across_columns_desc}: {@code Copy {0} recon
     * judgments from column {1} to {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copy {0} recon judgments from column {1} to {2}}
     */
    public static Localizable _recon_copy_across_columns_desc(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "recon_copy_across_columns_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_discard_judgments_brief}: {@code Discard recon
     * judgments for cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for cells in column {0}}
     */
    public static String recon_discard_judgments_brief(Object arg0) {
        return holder.format("recon_discard_judgments_brief", arg0);
    }

    /**
     * Key {@code recon_discard_judgments_brief}: {@code Discard recon
     * judgments for cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for cells in column {0}}
     */
    public static Localizable _recon_discard_judgments_brief(Object arg0) {
        return new Localizable(holder, "recon_discard_judgments_brief", arg0);
    }

    /**
     * Key {@code row_addition_brief}: {@code Add rows}.
     * 
     * @return
     *     {@code Add rows}
     */
    public static String row_addition_brief() {
        return holder.format("row_addition_brief");
    }

    /**
     * Key {@code row_addition_brief}: {@code Add rows}.
     * 
     * @return
     *     {@code Add rows}
     */
    public static Localizable _row_addition_brief() {
        return new Localizable(holder, "row_addition_brief");
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_not_combined_pos_brief}:
     * {@code Transpose cells in {0} column(s) starting with {1} into rows in
     * two new columns named {2} and {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in {0} column(s) starting with {1} into rows in
     *     two new columns named {2} and {3}}
     */
    public static String cell_transpose_columns_into_rows_not_combined_pos_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("cell_transpose_columns_into_rows_not_combined_pos_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_not_combined_pos_brief}:
     * {@code Transpose cells in {0} column(s) starting with {1} into rows in
     * two new columns named {2} and {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in {0} column(s) starting with {1} into rows in
     *     two new columns named {2} and {3}}
     */
    public static Localizable _cell_transpose_columns_into_rows_not_combined_pos_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "cell_transpose_columns_into_rows_not_combined_pos_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code cell_multivalued_cell_join_brief}: {@code Join multi-valued
     * cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Join multi-valued cells in column {0}}
     */
    public static String cell_multivalued_cell_join_brief(Object arg0) {
        return holder.format("cell_multivalued_cell_join_brief", arg0);
    }

    /**
     * Key {@code cell_multivalued_cell_join_brief}: {@code Join multi-valued
     * cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Join multi-valued cells in column {0}}
     */
    public static Localizable _cell_multivalued_cell_join_brief(Object arg0) {
        return new Localizable(holder, "cell_multivalued_cell_join_brief", arg0);
    }

    /**
     * Key {@code recon_match_specific_topic_brief}: {@code Match specific
     * item {0} ({1}) to cells in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match specific item {0} ({1}) to cells in column {2}}
     */
    public static String recon_match_specific_topic_brief(Object arg0, Object arg1, Object arg2) {
        return holder.format("recon_match_specific_topic_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_match_specific_topic_brief}: {@code Match specific
     * item {0} ({1}) to cells in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match specific item {0} ({1}) to cells in column {2}}
     */
    public static Localizable _recon_match_specific_topic_brief(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "recon_match_specific_topic_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code cell_mass_edit_desc}: {@code Mass edit {0} cells in column
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mass edit {0} cells in column {1}}
     */
    public static String cell_mass_edit_desc(Object arg0, Object arg1) {
        return holder.format("cell_mass_edit_desc", arg0, arg1);
    }

    /**
     * Key {@code cell_mass_edit_desc}: {@code Mass edit {0} cells in column
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mass edit {0} cells in column {1}}
     */
    public static Localizable _cell_mass_edit_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "cell_mass_edit_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_clear_similar_cells_brief}: {@code Clear recon data
     * for cells containing "{0}" in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Clear recon data for cells containing "{0}" in column {1}}
     */
    public static String recon_clear_similar_cells_brief(Object arg0, Object arg1) {
        return holder.format("recon_clear_similar_cells_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_clear_similar_cells_brief}: {@code Clear recon data
     * for cells containing "{0}" in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Clear recon data for cells containing "{0}" in column {1}}
     */
    public static Localizable _recon_clear_similar_cells_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_clear_similar_cells_brief", arg0, arg1);
    }

    /**
     * Key {@code cell_text_transform_desc}: {@code Text transform on {0}
     * cells in column {1}: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Text transform on {0} cells in column {1}: {2}}
     */
    public static String cell_text_transform_desc(Object arg0, Object arg1, Object arg2) {
        return holder.format("cell_text_transform_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code cell_text_transform_desc}: {@code Text transform on {0}
     * cells in column {1}: {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Text transform on {0} cells in column {1}: {2}}
     */
    public static Localizable _cell_text_transform_desc(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "cell_text_transform_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_mark_new_topics_shared_desc}: {@code Mark to create
     * new items for {0} cells in column {1}, one item for each group of
     * similar cells}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for {0} cells in column {1}, one item
     *     for each group of similar cells}
     */
    public static String recon_mark_new_topics_shared_desc(Object arg0, Object arg1) {
        return holder.format("recon_mark_new_topics_shared_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_mark_new_topics_shared_desc}: {@code Mark to create
     * new items for {0} cells in column {1}, one item for each group of
     * similar cells}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for {0} cells in column {1}, one item
     *     for each group of similar cells}
     */
    public static Localizable _recon_mark_new_topics_shared_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_mark_new_topics_shared_desc", arg0, arg1);
    }

    /**
     * Key {@code cell_fill_down_brief}: {@code Fill down cells in column
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fill down cells in column {0}}
     */
    public static String cell_fill_down_brief(Object arg0) {
        return holder.format("cell_fill_down_brief", arg0);
    }

    /**
     * Key {@code cell_fill_down_brief}: {@code Fill down cells in column
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fill down cells in column {0}}
     */
    public static Localizable _cell_fill_down_brief(Object arg0) {
        return new Localizable(holder, "cell_fill_down_brief", arg0);
    }

    /**
     * Key {@code column_addition_by_fetching_urls_brief}: {@code Create
     * column {0} at index {1} by fetching URLs based on column {2} using
     * expression {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create column {0} at index {1} by fetching URLs based on column
     *     {2} using expression {3}}
     */
    public static String column_addition_by_fetching_urls_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("column_addition_by_fetching_urls_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code column_addition_by_fetching_urls_brief}: {@code Create
     * column {0} at index {1} by fetching URLs based on column {2} using
     * expression {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create column {0} at index {1} by fetching URLs based on column
     *     {2} using expression {3}}
     */
    public static Localizable _column_addition_by_fetching_urls_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "column_addition_by_fetching_urls_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code column_addition_by_fetching_urls_desc}: {@code Create new
     * column {0}, filling {1} rows by fetching URLs based on column {2} and
     * formulated as {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create new column {0}, filling {1} rows by fetching URLs based
     *     on column {2} and formulated as {3}}
     */
    public static String column_addition_by_fetching_urls_desc(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("column_addition_by_fetching_urls_desc", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code column_addition_by_fetching_urls_desc}: {@code Create new
     * column {0}, filling {1} rows by fetching URLs based on column {2} and
     * formulated as {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create new column {0}, filling {1} rows by fetching URLs based
     *     on column {2} and formulated as {3}}
     */
    public static Localizable _column_addition_by_fetching_urls_desc(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "column_addition_by_fetching_urls_desc", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code recon_judge_similar_cells_matched_desc}: {@code Match item
     * {0} ({1}) for {2} cells containing "{3}" in column {4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match item {0} ({1}) for {2} cells containing "{3}" in column
     *     {4}}
     */
    public static String recon_judge_similar_cells_matched_desc(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return holder.format("recon_judge_similar_cells_matched_desc", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code recon_judge_similar_cells_matched_desc}: {@code Match item
     * {0} ({1}) for {2} cells containing "{3}" in column {4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match item {0} ({1}) for {2} cells containing "{3}" in column
     *     {4}}
     */
    public static Localizable _recon_judge_similar_cells_matched_desc(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Localizable(holder, "recon_judge_similar_cells_matched_desc", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code column_move_brief}: {@code Move column {0} to position
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Move column {0} to position {1}}
     */
    public static String column_move_brief(Object arg0, Object arg1) {
        return holder.format("column_move_brief", arg0, arg1);
    }

    /**
     * Key {@code column_move_brief}: {@code Move column {0} to position
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Move column {0} to position {1}}
     */
    public static Localizable _column_move_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "column_move_brief", arg0, arg1);
    }

    /**
     * Key {@code column_split_separator_brief}: {@code Split column {0} by
     * separator}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Split column {0} by separator}
     */
    public static String column_split_separator_brief(Object arg0) {
        return holder.format("column_split_separator_brief", arg0);
    }

    /**
     * Key {@code column_split_separator_brief}: {@code Split column {0} by
     * separator}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Split column {0} by separator}
     */
    public static Localizable _column_split_separator_brief(Object arg0) {
        return new Localizable(holder, "column_split_separator_brief", arg0);
    }

    /**
     * Key {@code row_flag_brief}: {@code Flag rows}.
     * 
     * @return
     *     {@code Flag rows}
     */
    public static String row_flag_brief() {
        return holder.format("row_flag_brief");
    }

    /**
     * Key {@code row_flag_brief}: {@code Flag rows}.
     * 
     * @return
     *     {@code Flag rows}
     */
    public static Localizable _row_flag_brief() {
        return new Localizable(holder, "row_flag_brief");
    }

    /**
     * Key {@code row_unstar_brief}: {@code Unstar rows}.
     * 
     * @return
     *     {@code Unstar rows}
     */
    public static String row_unstar_brief() {
        return holder.format("row_unstar_brief");
    }

    /**
     * Key {@code row_unstar_brief}: {@code Unstar rows}.
     * 
     * @return
     *     {@code Unstar rows}
     */
    public static Localizable _row_unstar_brief() {
        return new Localizable(holder, "row_unstar_brief");
    }

    /**
     * Key {@code recon_mark_new_topics_brief}: {@code Mark to create new
     * items for cells in column {0}, one item for each cell}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for cells in column {0}, one item for
     *     each cell}
     */
    public static String recon_mark_new_topics_brief(Object arg0) {
        return holder.format("recon_mark_new_topics_brief", arg0);
    }

    /**
     * Key {@code recon_mark_new_topics_brief}: {@code Mark to create new
     * items for cells in column {0}, one item for each cell}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for cells in column {0}, one item for
     *     each cell}
     */
    public static Localizable _recon_mark_new_topics_brief(Object arg0) {
        return new Localizable(holder, "recon_mark_new_topics_brief", arg0);
    }

    /**
     * Key {@code recon_mark_new_topics_desc}: {@code Mark to create new
     * items for {0} cells in column {1}, one item for each cell}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for {0} cells in column {1}, one item
     *     for each cell}
     */
    public static String recon_mark_new_topics_desc(Object arg0, Object arg1) {
        return holder.format("recon_mark_new_topics_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_mark_new_topics_desc}: {@code Mark to create new
     * items for {0} cells in column {1}, one item for each cell}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for {0} cells in column {1}, one item
     *     for each cell}
     */
    public static Localizable _recon_mark_new_topics_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_mark_new_topics_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_copy_across_columns_brief}: {@code Copy recon
     * judgments from column {0} to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copy recon judgments from column {0} to {1}}
     */
    public static String recon_copy_across_columns_brief(Object arg0, Object arg1) {
        return holder.format("recon_copy_across_columns_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_copy_across_columns_brief}: {@code Copy recon
     * judgments from column {0} to {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copy recon judgments from column {0} to {1}}
     */
    public static Localizable _recon_copy_across_columns_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_copy_across_columns_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_judge_similar_cells_new_share_brief}: {@code Mark to
     * create one single new item for all cells containing "{0}" in column
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one single new item for all cells containing
     *     "{0}" in column {1}}
     */
    public static String recon_judge_similar_cells_new_share_brief(Object arg0, Object arg1) {
        return holder.format("recon_judge_similar_cells_new_share_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_judge_similar_cells_new_share_brief}: {@code Mark to
     * create one single new item for all cells containing "{0}" in column
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one single new item for all cells containing
     *     "{0}" in column {1}}
     */
    public static Localizable _recon_judge_similar_cells_new_share_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_judge_similar_cells_new_share_brief", arg0, arg1);
    }

    /**
     * Key {@code row_star_brief}: {@code Star rows}.
     * 
     * @return
     *     {@code Star rows}
     */
    public static String row_star_brief() {
        return holder.format("row_star_brief");
    }

    /**
     * Key {@code row_star_brief}: {@code Star rows}.
     * 
     * @return
     *     {@code Star rows}
     */
    public static Localizable _row_star_brief() {
        return new Localizable(holder, "row_star_brief");
    }

    /**
     * Key {@code recon_judge_similar_cells_none_desc}: {@code Discard recon
     * judgments for {0} cells containing "{1}" in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for {0} cells containing "{1}" in
     *     column {2}}
     */
    public static String recon_judge_similar_cells_none_desc(Object arg0, Object arg1, Object arg2) {
        return holder.format("recon_judge_similar_cells_none_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_judge_similar_cells_none_desc}: {@code Discard recon
     * judgments for {0} cells containing "{1}" in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for {0} cells containing "{1}" in
     *     column {2}}
     */
    public static Localizable _recon_judge_similar_cells_none_desc(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "recon_judge_similar_cells_none_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code row_removal_brief}: {@code Remove rows}.
     * 
     * @return
     *     {@code Remove rows}
     */
    public static String row_removal_brief() {
        return holder.format("row_removal_brief");
    }

    /**
     * Key {@code row_removal_brief}: {@code Remove rows}.
     * 
     * @return
     *     {@code Remove rows}
     */
    public static Localizable _row_removal_brief() {
        return new Localizable(holder, "row_removal_brief");
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_combined_pos_brief}:
     * {@code Transpose cells in {0} columns(s) starting with {1} into rows
     * in one new column named {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in {0} columns(s) starting with {1} into rows
     *     in one new column named {2}}
     */
    public static String cell_transpose_columns_into_rows_combined_pos_brief(Object arg0, Object arg1, Object arg2) {
        return holder.format("cell_transpose_columns_into_rows_combined_pos_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_combined_pos_brief}:
     * {@code Transpose cells in {0} columns(s) starting with {1} into rows
     * in one new column named {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in {0} columns(s) starting with {1} into rows
     *     in one new column named {2}}
     */
    public static Localizable _cell_transpose_columns_into_rows_combined_pos_brief(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "cell_transpose_columns_into_rows_combined_pos_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code cell_transpose_rows_into_columns_brief}: {@code Transpose
     * every {0} cells in column {1} into separate columns}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose every {0} cells in column {1} into separate columns}
     */
    public static String cell_transpose_rows_into_columns_brief(Object arg0, Object arg1) {
        return holder.format("cell_transpose_rows_into_columns_brief", arg0, arg1);
    }

    /**
     * Key {@code cell_transpose_rows_into_columns_brief}: {@code Transpose
     * every {0} cells in column {1} into separate columns}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose every {0} cells in column {1} into separate columns}
     */
    public static Localizable _cell_transpose_rows_into_columns_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "cell_transpose_rows_into_columns_brief", arg0, arg1);
    }

    /**
     * Key {@code column_addition_brief}: {@code Create column {0} at index
     * {1} based on column {2} using expression {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create column {0} at index {1} based on column {2} using
     *     expression {3}}
     */
    public static String column_addition_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("column_addition_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code column_addition_brief}: {@code Create column {0} at index
     * {1} based on column {2} using expression {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create column {0} at index {1} based on column {2} using
     *     expression {3}}
     */
    public static Localizable _column_addition_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "column_addition_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code cell_multivalued_cell_split_brief}: {@code Split
     * multi-valued cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Split multi-valued cells in column {0}}
     */
    public static String cell_multivalued_cell_split_brief(Object arg0) {
        return holder.format("cell_multivalued_cell_split_brief", arg0);
    }

    /**
     * Key {@code cell_multivalued_cell_split_brief}: {@code Split
     * multi-valued cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Split multi-valued cells in column {0}}
     */
    public static Localizable _cell_multivalued_cell_split_brief(Object arg0) {
        return new Localizable(holder, "cell_multivalued_cell_split_brief", arg0);
    }

    /**
     * Key {@code recon_match_best_candidates_brief}: {@code Match each cell
     * to its best recon candidate in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match each cell to its best recon candidate in column {0}}
     */
    public static String recon_match_best_candidates_brief(Object arg0) {
        return holder.format("recon_match_best_candidates_brief", arg0);
    }

    /**
     * Key {@code recon_match_best_candidates_brief}: {@code Match each cell
     * to its best recon candidate in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match each cell to its best recon candidate in column {0}}
     */
    public static Localizable _recon_match_best_candidates_brief(Object arg0) {
        return new Localizable(holder, "recon_match_best_candidates_brief", arg0);
    }

    /**
     * Key {@code cell_blank_down_brief}: {@code Blank down cells in column
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blank down cells in column {0}}
     */
    public static String cell_blank_down_brief(Object arg0) {
        return holder.format("cell_blank_down_brief", arg0);
    }

    /**
     * Key {@code cell_blank_down_brief}: {@code Blank down cells in column
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blank down cells in column {0}}
     */
    public static Localizable _cell_blank_down_brief(Object arg0) {
        return new Localizable(holder, "cell_blank_down_brief", arg0);
    }

    /**
     * Key {@code cell_text_transform_brief}: {@code Text transform on cells
     * in column {0} using expression {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Text transform on cells in column {0} using expression {1}}
     */
    public static String cell_text_transform_brief(Object arg0, Object arg1) {
        return holder.format("cell_text_transform_brief", arg0, arg1);
    }

    /**
     * Key {@code cell_text_transform_brief}: {@code Text transform on cells
     * in column {0} using expression {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Text transform on cells in column {0} using expression {1}}
     */
    public static Localizable _cell_text_transform_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "cell_text_transform_brief", arg0, arg1);
    }

    /**
     * Key {@code row_reorder_brief}: {@code Reorder rows}.
     * 
     * @return
     *     {@code Reorder rows}
     */
    public static String row_reorder_brief() {
        return holder.format("row_reorder_brief");
    }

    /**
     * Key {@code row_reorder_brief}: {@code Reorder rows}.
     * 
     * @return
     *     {@code Reorder rows}
     */
    public static Localizable _row_reorder_brief() {
        return new Localizable(holder, "row_reorder_brief");
    }

    /**
     * Key {@code cell_key_value_columnize_note_column_brief}: {@code
     * Columnize by key column {0} and value column {1} with note column
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Columnize by key column {0} and value column {1} with note
     *     column {2}}
     */
    public static String cell_key_value_columnize_note_column_brief(Object arg0, Object arg1, Object arg2) {
        return holder.format("cell_key_value_columnize_note_column_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code cell_key_value_columnize_note_column_brief}: {@code
     * Columnize by key column {0} and value column {1} with note column
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Columnize by key column {0} and value column {1} with note
     *     column {2}}
     */
    public static Localizable _cell_key_value_columnize_note_column_brief(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "cell_key_value_columnize_note_column_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_discard_judgments_clear_data_desc}: {@code Discard
     * recon judgments and clear recon data for {0} cells in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments and clear recon data for {0} cells in
     *     column {1}}
     */
    public static String recon_discard_judgments_clear_data_desc(Object arg0, Object arg1) {
        return holder.format("recon_discard_judgments_clear_data_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_discard_judgments_clear_data_desc}: {@code Discard
     * recon judgments and clear recon data for {0} cells in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments and clear recon data for {0} cells in
     *     column {1}}
     */
    public static Localizable _recon_discard_judgments_clear_data_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_discard_judgments_clear_data_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_extend_data_brief}: {@code Extend data at index {0}
     * based on column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Extend data at index {0} based on column {1}}
     */
    public static String recon_extend_data_brief(Object arg0, Object arg1) {
        return holder.format("recon_extend_data_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_extend_data_brief}: {@code Extend data at index {0}
     * based on column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Extend data at index {0} based on column {1}}
     */
    public static Localizable _recon_extend_data_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_extend_data_brief", arg0, arg1);
    }

    /**
     * Key {@code row_remove_duplicates_brief}: {@code Remove duplicate
     * rows}.
     * 
     * @return
     *     {@code Remove duplicate rows}
     */
    public static String row_remove_duplicates_brief() {
        return holder.format("row_remove_duplicates_brief");
    }

    /**
     * Key {@code row_remove_duplicates_brief}: {@code Remove duplicate
     * rows}.
     * 
     * @return
     *     {@code Remove duplicate rows}
     */
    public static Localizable _row_remove_duplicates_brief() {
        return new Localizable(holder, "row_remove_duplicates_brief");
    }

    /**
     * Key {@code recon_discard_judgments_clear_data_brief}: {@code Discard
     * recon judgments and clear recon data for cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments and clear recon data for cells in
     *     column {0}}
     */
    public static String recon_discard_judgments_clear_data_brief(Object arg0) {
        return holder.format("recon_discard_judgments_clear_data_brief", arg0);
    }

    /**
     * Key {@code recon_discard_judgments_clear_data_brief}: {@code Discard
     * recon judgments and clear recon data for cells in column {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments and clear recon data for cells in
     *     column {0}}
     */
    public static Localizable _recon_discard_judgments_clear_data_brief(Object arg0) {
        return new Localizable(holder, "recon_discard_judgments_clear_data_brief", arg0);
    }

    /**
     * Key {@code cell_mass_edit_brief}: {@code Mass edit cells in column
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mass edit cells in column {0}}
     */
    public static String cell_mass_edit_brief(Object arg0) {
        return holder.format("cell_mass_edit_brief", arg0);
    }

    /**
     * Key {@code cell_mass_edit_brief}: {@code Mass edit cells in column
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mass edit cells in column {0}}
     */
    public static Localizable _cell_mass_edit_brief(Object arg0) {
        return new Localizable(holder, "cell_mass_edit_brief", arg0);
    }

    /**
     * Key {@code column_addition_desc}: {@code Create new column {0} based
     * on column {1} by filling {2} rows with {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create new column {0} based on column {1} by filling {2} rows
     *     with {3}}
     */
    public static String column_addition_desc(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("column_addition_desc", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code column_addition_desc}: {@code Create new column {0} based
     * on column {1} by filling {2} rows with {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Create new column {0} based on column {1} by filling {2} rows
     *     with {3}}
     */
    public static Localizable _column_addition_desc(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "column_addition_desc", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code recon_judge_similar_cells_matched_brief}: {@code Match item
     * {0} ({1}) for cells containing "{2}" in column {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match item {0} ({1}) for cells containing "{2}" in column {3}}
     */
    public static String recon_judge_similar_cells_matched_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return holder.format("recon_judge_similar_cells_matched_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code recon_judge_similar_cells_matched_brief}: {@code Match item
     * {0} ({1}) for cells containing "{2}" in column {3}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Match item {0} ({1}) for cells containing "{2}" in column {3}}
     */
    public static Localizable _recon_judge_similar_cells_matched_brief(Object arg0, Object arg1, Object arg2, Object arg3) {
        return new Localizable(holder, "recon_judge_similar_cells_matched_brief", arg0, arg1, arg2, arg3);
    }

    /**
     * Key {@code recon_use_values_as_identifiers_desc}: {@code Use values as
     * reconciliation identifiers for {0} cells in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use values as reconciliation identifiers for {0} cells in
     *     column {1}}
     */
    public static String recon_use_values_as_identifiers_desc(Object arg0, Object arg1) {
        return holder.format("recon_use_values_as_identifiers_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_use_values_as_identifiers_desc}: {@code Use values as
     * reconciliation identifiers for {0} cells in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Use values as reconciliation identifiers for {0} cells in
     *     column {1}}
     */
    public static Localizable _recon_use_values_as_identifiers_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_use_values_as_identifiers_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_judge_similar_cells_new_share_desc}: {@code Mark to
     * create one single new item for {0} cells containing "{1}" in column
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one single new item for {0} cells containing
     *     "{1}" in column {2}}
     */
    public static String recon_judge_similar_cells_new_share_desc(Object arg0, Object arg1, Object arg2) {
        return holder.format("recon_judge_similar_cells_new_share_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_judge_similar_cells_new_share_desc}: {@code Mark to
     * create one single new item for {0} cells containing "{1}" in column
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create one single new item for {0} cells containing
     *     "{1}" in column {2}}
     */
    public static Localizable _recon_judge_similar_cells_new_share_desc(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "recon_judge_similar_cells_new_share_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_not_combined_neg_brief}:
     * {@code Transpose cells in columns starting with {0} into rows in two
     * new columns named {1} and {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in columns starting with {0} into rows in two
     *     new columns named {1} and {2}}
     */
    public static String cell_transpose_columns_into_rows_not_combined_neg_brief(Object arg0, Object arg1, Object arg2) {
        return holder.format("cell_transpose_columns_into_rows_not_combined_neg_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code cell_transpose_columns_into_rows_not_combined_neg_brief}:
     * {@code Transpose cells in columns starting with {0} into rows in two
     * new columns named {1} and {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Transpose cells in columns starting with {0} into rows in two
     *     new columns named {1} and {2}}
     */
    public static Localizable _cell_transpose_columns_into_rows_not_combined_neg_brief(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "cell_transpose_columns_into_rows_not_combined_neg_brief", arg0, arg1, arg2);
    }

    /**
     * Key {@code column_reorder_brief}: {@code Reorder columns}.
     * 
     * @return
     *     {@code Reorder columns}
     */
    public static String column_reorder_brief() {
        return holder.format("column_reorder_brief");
    }

    /**
     * Key {@code column_reorder_brief}: {@code Reorder columns}.
     * 
     * @return
     *     {@code Reorder columns}
     */
    public static Localizable _column_reorder_brief() {
        return new Localizable(holder, "column_reorder_brief");
    }

    /**
     * Key {@code recon_mark_new_topics_shared_brief}: {@code Mark to create
     * new items for cells in column {0}, one item for each group of similar
     * cells}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for cells in column {0}, one item for
     *     each group of similar cells}
     */
    public static String recon_mark_new_topics_shared_brief(Object arg0) {
        return holder.format("recon_mark_new_topics_shared_brief", arg0);
    }

    /**
     * Key {@code recon_mark_new_topics_shared_brief}: {@code Mark to create
     * new items for cells in column {0}, one item for each group of similar
     * cells}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Mark to create new items for cells in column {0}, one item for
     *     each group of similar cells}
     */
    public static Localizable _recon_mark_new_topics_shared_brief(Object arg0) {
        return new Localizable(holder, "recon_mark_new_topics_shared_brief", arg0);
    }

    /**
     * Key {@code recon_discard_judgments_desc}: {@code Discard recon
     * judgments for {0} cells in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for {0} cells in column {1}}
     */
    public static String recon_discard_judgments_desc(Object arg0, Object arg1) {
        return holder.format("recon_discard_judgments_desc", arg0, arg1);
    }

    /**
     * Key {@code recon_discard_judgments_desc}: {@code Discard recon
     * judgments for {0} cells in column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Discard recon judgments for {0} cells in column {1}}
     */
    public static Localizable _recon_discard_judgments_desc(Object arg0, Object arg1) {
        return new Localizable(holder, "recon_discard_judgments_desc", arg0, arg1);
    }

    /**
     * Key {@code cell_key_value_columnize_brief}: {@code Columnize by key
     * column {0} and value column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Columnize by key column {0} and value column {1}}
     */
    public static String cell_key_value_columnize_brief(Object arg0, Object arg1) {
        return holder.format("cell_key_value_columnize_brief", arg0, arg1);
    }

    /**
     * Key {@code cell_key_value_columnize_brief}: {@code Columnize by key
     * column {0} and value column {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Columnize by key column {0} and value column {1}}
     */
    public static Localizable _cell_key_value_columnize_brief(Object arg0, Object arg1) {
        return new Localizable(holder, "cell_key_value_columnize_brief", arg0, arg1);
    }

    /**
     * Key {@code recon_clear_similar_cells_desc}: {@code Clear recon data
     * for {0} cells containing "{1}" in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Clear recon data for {0} cells containing "{1}" in column {2}}
     */
    public static String recon_clear_similar_cells_desc(Object arg0, Object arg1, Object arg2) {
        return holder.format("recon_clear_similar_cells_desc", arg0, arg1, arg2);
    }

    /**
     * Key {@code recon_clear_similar_cells_desc}: {@code Clear recon data
     * for {0} cells containing "{1}" in column {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Clear recon data for {0} cells containing "{1}" in column {2}}
     */
    public static Localizable _recon_clear_similar_cells_desc(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "recon_clear_similar_cells_desc", arg0, arg1, arg2);
    }

}
