/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="7.24.2")
final class DefaultFlowModels {
    static boolean isDefaultAdditionalTaintStep(Expression srcExpression, Cursor srcCursor, Expression sinkExpression, Cursor sinkCursor) {
        return DefaultFlowModels.isLocalAdditionalTaintStep(srcExpression, srcCursor, sinkExpression, sinkCursor);
    }

    private static boolean isLocalAdditionalTaintStep(Expression srcExpression, Cursor srcCursor, Expression sinkExpression, Cursor sinkCursor) {
        return AdditionalLocalTaint.isStringAddTaintStep(srcExpression, srcCursor, sinkExpression, sinkCursor);
    }

    private DefaultFlowModels() {
    }

    private static final class AdditionalLocalTaint {
        private AdditionalLocalTaint() {
        }

        private static boolean isStringAddTaintStep(Expression srcExpression, Cursor srcCursor, Expression sinkExpression, Cursor sinkCursor) {
            if (sinkExpression instanceof J.Binary) {
                J.Binary binary = (J.Binary)sinkExpression;
                return J.Binary.Type.Addition.equals((Object)binary.getOperator()) && (binary.getLeft() == srcExpression || binary.getRight() == srcExpression) && TypeUtils.isOfClassType((JavaType)binary.getType(), (String)"java.lang.String");
            }
            return false;
        }
    }
}

