/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.expr;

import fj.data.Either;
import fj.data.Validation;
import java.util.Objects;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.expr.InstanceAccess;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.java.tree.J;

class InstanceAccessBase
implements InstanceAccess {
    final Cursor cursor;
    final Either<J.Identifier, J.FieldAccess> expression;

    @Override
    public UUID getId() {
        return (UUID)this.expression.either(J.Identifier::getId, J.FieldAccess::getId);
    }

    public String getName() {
        return (String)this.expression.either(J.Identifier::getSimpleName, fa -> fa.getName().getSimpleName());
    }

    @Override
    public boolean isOwnInstanceAccess() {
        return true;
    }

    public boolean equals(Object obj) {
        return Top.equals(this, obj);
    }

    public int hashCode() {
        return Top.hashCode(this);
    }

    static Validation<TraitErrors, InstanceAccessBase> viewOf(Cursor cursor) {
        J.Identifier identifier;
        Objects.requireNonNull(cursor, "cursor must not be null");
        Object maybeTree = cursor.getValue();
        if (maybeTree instanceof J.FieldAccess) {
            J.FieldAccess fieldAccess = (J.FieldAccess)maybeTree;
            if ("this".equals(fieldAccess.getName().getSimpleName()) || "super".equals(fieldAccess.getName().getSimpleName())) {
                return Validation.success((Object)new InstanceAccessBase(cursor, (Either<J.Identifier, J.FieldAccess>)Either.right((Object)fieldAccess)));
            }
        } else if (maybeTree instanceof J.Identifier && ("this".equals((identifier = (J.Identifier)maybeTree).getSimpleName()) || "super".equals(identifier.getSimpleName()))) {
            return Validation.success((Object)new InstanceAccessBase(cursor, (Either<J.Identifier, J.FieldAccess>)Either.left((Object)identifier)));
        }
        return TraitErrors.invalidTraitCreationType(InstanceAccess.class, cursor, J.Identifier.class, J.FieldAccess.class);
    }

    public InstanceAccessBase(Cursor cursor, Either<J.Identifier, J.FieldAccess> expression) {
        this.cursor = cursor;
        this.expression = expression;
    }
}

