/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.analysis.controlflow.Guard;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.ExternalFlowModels;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Incubating(since="7.24.0")
public abstract class LocalFlowSpec<Source extends Expression, Sink extends J> {
    protected final Type sourceType;
    protected final Type sinkType;

    protected LocalFlowSpec() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: LocalFlowSpec constructed without actual type information");
        }
        this.sourceType = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        this.sinkType = ((ParameterizedType)superClass).getActualTypeArguments()[1];
    }

    public Class<?> getSourceType() {
        return (Class)this.sourceType;
    }

    public Class<?> getSinkType() {
        return (Class)this.sinkType;
    }

    public abstract boolean isSource(DataFlowNode var1);

    public abstract boolean isSink(DataFlowNode var1);

    public final boolean isFlowStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
        return ExternalFlowModels.instance().isAdditionalFlowStep(srcNode, sinkNode) || this.isAdditionalFlowStep(srcNode, sinkNode);
    }

    public boolean isAdditionalFlowStep(DataFlowNode srcNode, DataFlowNode sinkNode) {
        return false;
    }

    public boolean isBarrierGuard(Guard guard, boolean branch) {
        return false;
    }

    public boolean isBarrier(Expression expression, Cursor cursor) {
        return false;
    }
}

